/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.resource;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public final class FileAssociationImages {
    private static FileAssociationImages __Default;
    private ImageRegistry _ExternalEditorImageRegistry;
    private ImageRegistry _IdeEditorImageRegistry;

    public static final FileAssociationImages getDefault() {
        if (__Default == null) {
            __Default = new FileAssociationImages();
        }
        return __Default;
    }

    public Image get(String fileName, boolean preferIdeEditor) {
        int index;
        Image image = null;
        if (preferIdeEditor) {
            if (this._IdeEditorImageRegistry != null && (image = this._IdeEditorImageRegistry.get(fileName)) != null) {
                return image;
            }
            image = this.getIdeEditorImage(fileName);
            if (image != null) {
                if (this._IdeEditorImageRegistry == null) {
                    this._IdeEditorImageRegistry = new ImageRegistry();
                }
                this._IdeEditorImageRegistry.put(fileName, image);
                return image;
            }
        }
        if ((index = fileName.lastIndexOf(46)) > -1 && index < fileName.length() - 1) {
            String extension = fileName.substring(index);
            if (this._ExternalEditorImageRegistry != null && (image = this._ExternalEditorImageRegistry.get(extension)) != null) {
                return image;
            }
            image = this.getExternalEditorImage(extension);
            if (image != null) {
                if (this._ExternalEditorImageRegistry == null) {
                    this._ExternalEditorImageRegistry = new ImageRegistry();
                }
                this._ExternalEditorImageRegistry.put(extension, image);
                return image;
            }
        }
        image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        return image;
    }

    public void dispose() {
        if (this._IdeEditorImageRegistry != null) {
            this._IdeEditorImageRegistry.dispose();
            this._IdeEditorImageRegistry = null;
        }
        if (this._ExternalEditorImageRegistry != null) {
            this._ExternalEditorImageRegistry.dispose();
            this._ExternalEditorImageRegistry = null;
        }
    }

    private Image getExternalEditorImage(String extension) {
        Program program = Program.findProgram((String)extension);
        ImageData imageData = program == null ? null : program.getImageData();
        Image image = null;
        if (imageData != null) {
            image = new Image((Device)Display.getCurrent(), imageData);
        }
        return image;
    }

    private Image getIdeEditorImage(String fileName) {
        Image image = null;
        IWorkbench workBench = PlatformUI.getWorkbench();
        IEditorDescriptor editorDescriptor = workBench.getEditorRegistry().getDefaultEditor(fileName);
        if (editorDescriptor != null) {
            ImageDescriptor imageDescriptor = editorDescriptor.getImageDescriptor();
            if (imageDescriptor != null) {
                image = imageDescriptor.createImage();
            } else {
                Image sourceImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
                image = new Image((Device)Display.getCurrent(), sourceImage, 0);
            }
        }
        return image;
    }
}

