/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.runtime;

import com.fusesource.zk.core.data.AbstractConnectionDescriptor;
import com.fusesource.zk.core.runtime.IConnectionDescriptorXmlSerializer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ConnectionDescriptorFiles<T extends AbstractConnectionDescriptor<T>> {
    public static final String FILE_EXTENSION = ".xml";
    public static final String XML_TAG_CONNECTION = "Connection";
    public static final String XML_TAG_NAME = "Name";
    public static final String XML_TAG_VERSION = "Version";
    private final File _Directory;
    private final Map<String, IConnectionDescriptorXmlSerializer<T>> _Serializers;
    private final String _XmlWriteVersion;

    public ConnectionDescriptorFiles(File directory, String xmlWriteVersion) {
        this._Directory = directory;
        this._XmlWriteVersion = xmlWriteVersion;
        this._Serializers = new HashMap<String, IConnectionDescriptorXmlSerializer<T>>();
    }

    public void addSerializer(String xmlVersion, IConnectionDescriptorXmlSerializer<T> serializer) {
        this._Serializers.put(xmlVersion, serializer);
    }

    public boolean delete(T connectionDescriptor) {
        this.createDirectory();
        File file = this.getConnectionFile(connectionDescriptor);
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }

    public boolean exists(String name) {
        return this.getNames().contains(name);
    }

    public final File getDirectory() {
        return this._Directory;
    }

    public Set<String> getNames() {
        this.createDirectory();
        File[] connectionFiles = this.getConnectionFiles();
        if (connectionFiles == null) {
            return Collections.emptySet();
        }
        TreeSet<String> names = new TreeSet<String>();
        File[] fileArray = connectionFiles;
        int n = connectionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block20: {
                File connectionFile = fileArray[n2];
                FileReader reader = null;
                try {
                    reader = new FileReader(connectionFile);
                    XMLMemento connectionMemento = XMLMemento.createReadRoot((Reader)reader);
                    String name = connectionMemento.getString(XML_TAG_NAME);
                    names.add(name);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block20;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block20;
                }
                catch (WorkbenchException e) {
                    try {
                        e.printStackTrace();
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return names;
    }

    public final String getXmlWriteVersion() {
        return this._XmlWriteVersion;
    }

    public T load(String name) {
        File connectionFile = this.getConnectionFile(name);
        return this.load(connectionFile);
    }

    public Set<T> loadAll() {
        this.createDirectory();
        File[] connectionFiles = this.getConnectionFiles();
        if (connectionFiles == null || connectionFiles.length == 0) {
            return Collections.emptySet();
        }
        TreeSet<T> connectionSet = new TreeSet<T>();
        File[] fileArray = connectionFiles;
        int n = connectionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File connectionFile = fileArray[n2];
            T connectionDescriptor = this.load(connectionFile);
            if (connectionDescriptor != null) {
                connectionSet.add(connectionDescriptor);
            }
            ++n2;
        }
        return connectionSet;
    }

    public void save(T connectionDescriptor) {
        this.createDirectory();
        XMLMemento memento = this.toXml(connectionDescriptor);
        File file = this.getConnectionFile(connectionDescriptor);
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                memento.save((Writer)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void createDirectory() {
        File dir = this.getDirectory();
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    protected T fromXml(XMLMemento memento) {
        String version = memento.getString(XML_TAG_VERSION);
        IConnectionDescriptorXmlSerializer<T> serializer = this._Serializers.get(version);
        return serializer.fromXml(memento);
    }

    protected File getConnectionFile(String name) {
        return new File(this.getDirectory(), String.valueOf(name) + FILE_EXTENSION);
    }

    protected File getConnectionFile(T connectionDescriptor) {
        return this.getConnectionFile(((AbstractConnectionDescriptor)connectionDescriptor).getName());
    }

    protected File[] getConnectionFiles() {
        return this._Directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(ConnectionDescriptorFiles.FILE_EXTENSION);
            }
        });
    }

    protected T load(File connectionFile) {
        T connectionDescriptor;
        block18: {
            connectionDescriptor = null;
            FileReader reader = null;
            try {
                reader = new FileReader(connectionFile);
                XMLMemento connectionMemento = XMLMemento.createReadRoot((Reader)reader);
                connectionDescriptor = this.fromXml(connectionMemento);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block18;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break block18;
            }
            catch (WorkbenchException e) {
                try {
                    e.printStackTrace();
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return connectionDescriptor;
    }

    protected XMLMemento toXml(T connectionDescriptor) {
        String xmlWriteVersion = this.getXmlWriteVersion();
        IConnectionDescriptorXmlSerializer<T> serializer = this._Serializers.get(xmlWriteVersion);
        XMLMemento memento = XMLMemento.createWriteRoot((String)XML_TAG_CONNECTION);
        memento.putString(XML_TAG_VERSION, xmlWriteVersion);
        memento.putString(XML_TAG_NAME, ((AbstractConnectionDescriptor)connectionDescriptor).getName());
        serializer.toXml(connectionDescriptor, memento);
        return memento;
    }
}

