/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.ui;

import com.fusesource.zk.core.resource.FileAssociationImages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

public final class FileEditor {
    private final File _File;
    private Image _FileAssociationImage;
    private long _LastRead;
    private final boolean _PreferIdeEditor;
    private final boolean _TempFile;

    public static FileEditor createTempFileEditor(String prefix, String suffix, File directory, byte[] data, boolean preferIdeEditor) throws IOException {
        File file = null;
        file = File.createTempFile(prefix, suffix, directory);
        file.deleteOnExit();
        if (data != null) {
            FileOutputStream out = new FileOutputStream(file);
            try {
                out.write(data);
            }
            finally {
                out.close();
            }
        }
        return new FileEditor(file, preferIdeEditor, true);
    }

    public static IEditorPart editFile(File file, boolean preferIdeEditor) throws IOException, PartInitException {
        IEditorDescriptor editorDescriptor;
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            throw new IOException("Invalid file: '" + file + "'");
        }
        IWorkbench workBench = PlatformUI.getWorkbench();
        IWorkbenchPage page = workBench.getActiveWorkbenchWindow().getActivePage();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(location);
        FileStoreEditorInput fileStoreEditorInput = new FileStoreEditorInput(fileStore);
        String editorId = "org.eclipse.ui.systemExternalEditor";
        if (preferIdeEditor && (editorDescriptor = workBench.getEditorRegistry().getDefaultEditor(file.getName())) != null) {
            editorId = editorDescriptor.getId();
        }
        return page.openEditor((IEditorInput)fileStoreEditorInput, editorId);
    }

    public static Image getFileAssociationImage(File file, boolean preferIdeEditor) {
        return FileEditor.getFileAssociationImage(file.getName(), preferIdeEditor);
    }

    public static Image getFileAssociationImage(String fileName, boolean preferIdeEditor) {
        return FileAssociationImages.getDefault().get(fileName, preferIdeEditor);
    }

    public static byte[] readFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        try {
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                throw new IOException("Failed to completely read file '" + file.getName() + "'.");
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return bytes;
    }

    public FileEditor(File file) {
        this(file, true, false);
    }

    public FileEditor(File file, boolean preferIdeEditor) {
        this(file, preferIdeEditor, false);
    }

    public FileEditor(File file, boolean preferIdeEditor, boolean tempFile) {
        this._File = file;
        this._LastRead = this._File.lastModified();
        this._PreferIdeEditor = preferIdeEditor;
        this._TempFile = tempFile;
    }

    public IEditorPart edit() throws IOException, PartInitException {
        return FileEditor.editFile(this.getFile(), this.isPreferIdeEditor());
    }

    public File getFile() {
        return this._File;
    }

    public Image getFileAssociationImage() {
        if (this._FileAssociationImage == null) {
            this._FileAssociationImage = FileEditor.getFileAssociationImage(this.getFile(), this.isPreferIdeEditor());
        }
        return this._FileAssociationImage;
    }

    public long getLastModified() {
        return this.getFile().lastModified();
    }

    public long getLastRead() {
        return this._LastRead;
    }

    public boolean isModifiedSinceLastRead() {
        return this.getLastModified() > this.getLastRead();
    }

    public boolean isPreferIdeEditor() {
        return this._PreferIdeEditor;
    }

    public byte[] read() throws IOException {
        File file = this.getFile();
        byte[] bytes = FileEditor.readFile(file);
        this._LastRead = file.lastModified();
        return bytes;
    }

    public boolean isTempFile() {
        return this._TempFile;
    }

    public void dispose() {
        File file;
        if (this.isTempFile() && (file = this.getFile()).exists()) {
            file.delete();
        }
    }
}

