/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.viewers;

import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.viewers.ElementTypeAdapter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class BaseElementType
extends ElementTypeAdapter {
    public static DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
    private final List<BaseAction> _Actions = this.createActions();

    @Override
    public final List<BaseAction> getActions() {
        return this._Actions;
    }

    @Override
    public Object[] getChildren(Object parent) {
        int childCount = this.getChildCount(parent);
        Object[] children = new Object[childCount];
        int i = 0;
        while (i < childCount) {
            children[i] = this.getChildElement(parent, i);
            ++i;
        }
        return children;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    @Override
    public int getColumnIndex(String columnTitle) {
        String[] columnTitles = this.getColumnTitles();
        int i = 0;
        while (i < columnTitles.length) {
            if (columnTitles[i].equals(columnTitle)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        return null;
    }

    @Override
    public String getToolTipText(Object element) {
        return this.getText(element);
    }

    @Override
    public final String getColumnText(Object element, String columnTitle) {
        return this.getColumnText(element, this.getColumnIndex(columnTitle));
    }

    @Override
    public void packTable(Table table) {
        table.pack();
        TableColumn[] columns = table.getColumns();
        int[] columnWidths = this.getColumnWidths();
        int i = 0;
        while (i < columns.length) {
            int columnWidth = columnWidths[i];
            if (columnWidth == -1) {
                columns[i].pack();
            } else {
                columns[i].setWidth(columnWidth);
            }
            ++i;
        }
    }

    protected List<BaseAction> createActions() {
        return new ArrayList<BaseAction>();
    }
}

