/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.viewers;

import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.core.model.GenericDataModelManagerEvent;
import com.fusesource.zk.core.model.IGenericDataModelEventListener;
import com.fusesource.zk.core.model.IGenericDataModelManagerEventListener;
import com.fusesource.zk.core.reflect.SwtThreadSafeDelegatingInvocationHandler;
import com.fusesource.zk.core.viewers.AbstractCachingElementBinding;
import com.fusesource.zk.core.viewers.IElementBinding;
import org.eclipse.swt.widgets.Widget;

public class DataModelElementBinding
extends AbstractCachingElementBinding
implements IElementBinding {
    private final IGenericDataModelManagerEventListener _DataModelManagerEventListener;
    private final IGenericDataModelEventListener _DataModelEventListener = (IGenericDataModelEventListener)SwtThreadSafeDelegatingInvocationHandler.createProxyInstance(new DataModelEventListener(), IGenericDataModelEventListener.class, true);

    public DataModelElementBinding() {
        this._DataModelManagerEventListener = (IGenericDataModelManagerEventListener)SwtThreadSafeDelegatingInvocationHandler.createProxyInstance(new DataModelManagerEventListener(), IGenericDataModelManagerEventListener.class, true);
    }

    @Override
    protected boolean bindHook(Object element) {
        if (element instanceof DataModel) {
            DataModel dataModel = (DataModel)element;
            dataModel.addGenericEventListener(this._DataModelEventListener);
            return true;
        }
        if (element instanceof DataModelManager) {
            DataModelManager dataModelManager = (DataModelManager)element;
            dataModelManager.addGenericEventListener(this._DataModelManagerEventListener);
            return true;
        }
        return false;
    }

    @Override
    protected boolean unbindHook(Object element) {
        if (element instanceof DataModel) {
            DataModel dataModel = (DataModel)element;
            dataModel.removeGenericEventListener(this._DataModelEventListener);
            return true;
        }
        if (element instanceof DataModelManager) {
            DataModelManager dataModelManager = (DataModelManager)element;
            dataModelManager.removeGenericEventListener(this._DataModelManagerEventListener);
            return true;
        }
        return false;
    }

    public class DataModelEventListener
    implements IGenericDataModelEventListener,
    SwtThreadSafeDelegatingInvocationHandler.IWidgetProvider {
        @Override
        public void dataModelDataChanged(GenericDataModelEvent event) {
            DataModelElementBinding.this.getViewerType().refreshElement(DataModelElementBinding.this.getViewer(), event.getModel());
        }

        @Override
        public void dataModelDataRefreshed(GenericDataModelEvent event) {
            DataModelElementBinding.this.getViewerType().refreshElement(DataModelElementBinding.this.getViewer(), event.getModel());
        }

        @Override
        public void dataModelDestroyed(GenericDataModelEvent event) {
            DataModel<?, ?, ?> element = event.getModel();
            DataModelElementBinding.this.getViewerType().removeElement(DataModelElementBinding.this.getViewer(), element);
            DataModelElementBinding.this.unbind(element);
        }

        @Override
        public Widget getWidget() {
            return DataModelElementBinding.this.getViewer().getControl();
        }
    }

    public class DataModelManagerEventListener
    implements IGenericDataModelManagerEventListener,
    SwtThreadSafeDelegatingInvocationHandler.IWidgetProvider {
        @Override
        public void dataModelManagerDataModelAdded(GenericDataModelManagerEvent event) {
            DataModelElementBinding.this.getViewerType().addElement(DataModelElementBinding.this.getViewer(), event.getManager(), event.getModel());
        }

        @Override
        public void dataModelManagerDataModelRemoved(GenericDataModelManagerEvent event) {
            DataModelElementBinding.this.getViewerType().removeElement(DataModelElementBinding.this.getViewer(), event.getModel());
        }

        @Override
        public void dataModelManagerDestroyed(GenericDataModelManagerEvent event) {
        }

        @Override
        public Widget getWidget() {
            return DataModelElementBinding.this.getViewer().getControl();
        }
    }
}

