/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.viewers;

import com.fusesource.zk.core.viewers.Binding;
import com.fusesource.zk.core.viewers.IElementBinding;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public abstract class ElementBinding
extends Binding
implements IElementBinding {
    private final ControlDisposeListener _ControlDisposeListener = new ControlDisposeListener();

    @Override
    public void setViewer(StructuredViewer viewer) {
        this.removeViewerControlDisposeListener();
        super.setViewer(viewer);
        this.addViewerControlDisposeListener();
    }

    private void addViewerControlDisposeListener() {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        Control control = viewer.getControl();
        if (control.isDisposed()) {
            return;
        }
        control.addDisposeListener((DisposeListener)this._ControlDisposeListener);
    }

    private void removeViewerControlDisposeListener() {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        Control control = viewer.getControl();
        control.removeDisposeListener((DisposeListener)this._ControlDisposeListener);
    }

    private class ControlDisposeListener
    implements DisposeListener {
        private ControlDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            ElementBinding.this.unbindAll();
        }
    }
}

