/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.viewers;

import com.fusesource.zk.core.viewers.ElementTypes;
import com.fusesource.zk.core.viewers.IElementBinding;
import com.fusesource.zk.core.viewers.IViewerType;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class PluggableContentProvider {
    private final IElementBinding _ElementBinding;
    private final ElementTypes _ElementTypes;
    private Object _Input;
    private StructuredViewer _Viewer;
    private final IViewerType _ViewerType;

    public PluggableContentProvider(IViewerType viewerType, ElementTypes elementTypes, IElementBinding elementBinding) {
        this._ViewerType = viewerType;
        this._ElementTypes = elementTypes;
        this._ElementBinding = elementBinding;
        if (this._ElementBinding != null) {
            this._ElementBinding.setViewerType(this._ViewerType);
        }
    }

    public void dispose() {
        if (this._ElementBinding != null) {
            this._ElementBinding.unbindAll();
            this._ElementBinding.dispose();
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = this._ElementTypes.get(parentElement).getChildren(parentElement);
        this.bindElements(children);
        return children;
    }

    public IElementBinding getElementBinding() {
        return this._ElementBinding;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this._Input) {
            Object[] elements = this._ElementTypes.get(inputElement).getChildren(inputElement);
            this.bindElements(elements);
            return elements;
        }
        throw new IllegalArgumentException("Unexpected inputElement: " + inputElement);
    }

    public ElementTypes getElementTypes() {
        return this._ElementTypes;
    }

    public Object getInput() {
        return this._Input;
    }

    public Object getParent(Object element) {
        return this._ElementTypes.get(element).getParent(element);
    }

    public StructuredViewer getViewer() {
        return this._Viewer;
    }

    public IViewerType getViewerType() {
        return this._ViewerType;
    }

    public boolean hasChildren(Object element) {
        return this.getChildCount(element) > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.setViewer((StructuredViewer)viewer);
        this.setInput(newInput);
    }

    public void updateChildCount(Object element, int currentChildCount) {
        int childCount = this.getChildCount(element);
        if (childCount != currentChildCount) {
            this._ViewerType.setChildCount(this.getViewer(), element, childCount);
        }
    }

    public void updateElement(int index) {
        this.runWithBusyIndicator(new UpdateElementRunnable(this._Input, index));
    }

    public void updateElement(Object parent, int index) {
        this.runWithBusyIndicator(new UpdateElementRunnable(parent, index));
    }

    private void bindElement(Object element) {
        if (this._ElementBinding == null) {
            return;
        }
        this._ElementBinding.bind(element);
    }

    private void bindElements(Object[] elements) {
        if (this._ElementBinding == null) {
            return;
        }
        if (elements == null) {
            return;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.bindElement(element);
            ++n2;
        }
    }

    private int getChildCount(Object parent) {
        return this._ElementTypes.get(parent).getChildCount(parent);
    }

    private Object getChildElement(Object parent, int index) {
        Object element = this._ElementTypes.get(parent).getChildElement(parent, index);
        this.bindElement(element);
        return element;
    }

    private void runWithBusyIndicator(Runnable runnable) {
        BusyIndicator.showWhile((Display)this._Viewer.getControl().getDisplay(), (Runnable)runnable);
    }

    private void setInput(Object input) {
        this._Input = input;
        if (this._Input != null && this._ElementBinding != null) {
            this._ElementBinding.bind(this._Input);
        }
    }

    private void setViewer(StructuredViewer viewer) {
        this._Viewer = viewer;
        if (this._Viewer != null && this._ElementBinding != null) {
            this._ElementBinding.setViewer(this._Viewer);
        }
    }

    private void updateElementInner(Object parent, int index) {
        Object element = this.getChildElement(parent, index);
        if (element == null) {
            return;
        }
        this._ViewerType.updateElement(this._Viewer, parent, index, element);
        int childCount = this.getChildCount(element);
        this._ViewerType.setChildCount(this._Viewer, element, childCount);
    }

    private class UpdateElementRunnable
    implements Runnable {
        private int _Index;
        private Object _Parent;

        public UpdateElementRunnable(Object parent, int index) {
            this._Parent = parent;
            this._Index = index;
        }

        @Override
        public void run() {
            PluggableContentProvider.this.updateElementInner(this._Parent, this._Index);
        }
    }
}

