/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.viewers;

import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.reflect.DelegatingInvocationHandler;
import com.fusesource.zk.core.viewers.DataModelElementBinding;
import com.fusesource.zk.core.viewers.ElementTypes;
import com.fusesource.zk.core.viewers.ElementTypesLabelProvider;
import com.fusesource.zk.core.viewers.IElementBinding;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.viewers.IViewerType;
import com.fusesource.zk.core.viewers.PluggableContentProvider;
import com.fusesource.zk.core.viewers.TableViewerType;
import com.fusesource.zk.core.viewers.TreeViewerType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;

public final class ViewerFactory {
    public static TableViewer createDataModelTableViewer(Composite parent, int style, ElementTypes elementTypes, Object input) {
        DataModelElementBinding elementBinding = new DataModelElementBinding();
        return ViewerFactory.createTableViewer(parent, style, elementTypes, input, elementBinding);
    }

    public static TableViewer createDataModelTableViewer(IWorkbenchPartSite site, Table table, Class<?> dataModelClass, final IElementType dataModelElementType, Object input, IElementType inputElementType) {
        TableViewer tableViewer = ViewerFactory.createTableViewer(table, dataModelClass, dataModelElementType, input, inputElementType, new DataModelElementBinding());
        List<BaseAction> tableActions = dataModelElementType.getActions();
        if (tableActions != null) {
            for (BaseAction action : tableActions) {
                action.setSelectionProvider((ISelectionProvider)tableViewer);
            }
            MenuManager menuManager = new MenuManager("#PopupMenu");
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    dataModelElementType.fillContextMenu(manager);
                }
            });
            Menu menu = menuManager.createContextMenu((Control)table);
            table.setMenu(menu);
            site.registerContextMenu(menuManager, (ISelectionProvider)tableViewer);
        }
        return tableViewer;
    }

    public static TableViewer createDataModelTableViewer(Table table, ElementTypes elementTypes, Object input) {
        DataModelElementBinding elementBinding = new DataModelElementBinding();
        return ViewerFactory.createTableViewer(table, elementTypes, input, elementBinding);
    }

    public static TreeViewer createDataModelTreeViewer(Composite parent, int style, ElementTypes elementTypes, Object input) {
        DataModelElementBinding elementBinding = new DataModelElementBinding();
        return ViewerFactory.createTreeViewer(parent, style, elementTypes, input, elementBinding);
    }

    public static TableViewer createTableViewer(Composite parent, int style, ElementTypes elementTypes, Object input) {
        return ViewerFactory.createTableViewer(parent, style, elementTypes, input, null);
    }

    public static TableViewer createTableViewer(Composite parent, int style, ElementTypes elementTypes, Object input, IElementBinding elementBinding) {
        TableViewer tableViewer = new TableViewer(parent, style);
        ViewerFactory.initTableViewer(tableViewer, elementTypes, input, elementBinding);
        return tableViewer;
    }

    public static TableViewer createTableViewer(Table table, Class<?> elementClass, IElementType elementType, Object input, IElementType inputElementType, IElementBinding elementBinding) {
        ElementTypes elementTypes = ViewerFactory.createTableElementTypes(elementClass, elementType, input, inputElementType);
        ViewerFactory.createTableColumns(table, elementType);
        TableViewer tableViewer = ViewerFactory.createTableViewer(table, elementTypes, input, elementBinding);
        elementType.packTable(table);
        return tableViewer;
    }

    public static TableViewer createTableViewer(Table table, ElementTypes elementTypes, Object input, IElementBinding elementBinding) {
        TableViewer tableViewer = new TableViewer(table);
        ViewerFactory.initTableViewer(tableViewer, elementTypes, input, elementBinding);
        return tableViewer;
    }

    public static TreeViewer createTreeViewer(Composite parent, int style, ElementTypes elementTypes, Object input, IElementBinding elementBinding) {
        TreeViewer treeViewer = new TreeViewer(parent, style);
        ViewerFactory.initTreeViewer(treeViewer, elementTypes, input, elementBinding);
        return treeViewer;
    }

    public static TreeViewer createTreeViewer(Tree tree, ElementTypes elementTypes, Object input, IElementBinding elementBinding) {
        TreeViewer treeViewer = new TreeViewer(tree);
        ViewerFactory.initTreeViewer(treeViewer, elementTypes, input, elementBinding);
        return treeViewer;
    }

    private static void createTableColumns(Table table, IElementType tableElementType) {
        String[] columnTitles = tableElementType.getColumnTitles();
        int[] columnAlignments = tableElementType.getColumnAlignments();
        int i = 0;
        while (i < columnTitles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnTitles[i]);
            column.setAlignment(columnAlignments[i]);
            column.setMoveable(true);
            ++i;
        }
        table.setHeaderVisible(true);
    }

    private static ElementTypes createTableElementTypes(Class<?> dataModelClass, IElementType dataModelElementType, Object input, IElementType inputElementType) {
        ElementTypes elementTypes = new ElementTypes();
        elementTypes.add(input.getClass(), inputElementType);
        elementTypes.add(dataModelClass, dataModelElementType);
        return elementTypes;
    }

    private static void initTableViewer(TableViewer tableViewer, ElementTypes elementTypes, Object input, IElementBinding elementBinding) {
        TableViewerType viewerType = new TableViewerType();
        Table table = tableViewer.getTable();
        Class<IStructuredContentProvider> contentProviderInterfaceType = IStructuredContentProvider.class;
        if ((table.getStyle() & 0x10000000) != 0) {
            contentProviderInterfaceType = ILazyContentProvider.class;
        }
        ViewerFactory.registerTableListeners(table);
        ViewerFactory.initViewer((StructuredViewer)tableViewer, elementTypes, input, elementBinding, viewerType, contentProviderInterfaceType);
    }

    private static void initTreeViewer(TreeViewer treeViewer, ElementTypes elementTypes, Object input, IElementBinding elementBinding) {
        TreeViewerType viewerType = new TreeViewerType();
        Class<ITreeContentProvider> contentProviderInterfaceType = ITreeContentProvider.class;
        if ((treeViewer.getTree().getStyle() & 0x10000000) != 0) {
            contentProviderInterfaceType = ILazyTreeContentProvider.class;
        }
        ViewerFactory.initViewer((StructuredViewer)treeViewer, elementTypes, input, elementBinding, viewerType, contentProviderInterfaceType);
    }

    private static void initViewer(StructuredViewer viewer, ElementTypes elementTypes, Object input, IElementBinding elementBinding, IViewerType viewerType, Class<?> contentProviderInterfaceType) {
        PluggableContentProvider pluggableContentProvider = new PluggableContentProvider(viewerType, elementTypes, elementBinding);
        ElementTypesLabelProvider labelProvider = new ElementTypesLabelProvider(elementTypes);
        DelegatingInvocationHandler invocationHandler = new DelegatingInvocationHandler(pluggableContentProvider);
        IContentProvider contentProvider = (IContentProvider)Proxy.newProxyInstance(contentProviderInterfaceType.getClassLoader(), new Class[]{contentProviderInterfaceType}, (InvocationHandler)invocationHandler);
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setUseHashlookup(true);
        viewer.setInput(input);
    }

    private static void registerTableListeners(final Table table) {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (table.getItem(new Point(e.x, e.y)) == null) {
                    table.deselectAll();
                }
            }
        };
        table.addMouseListener((MouseListener)mouseListener);
        table.addDisposeListener(new DisposeListener((MouseListener)mouseListener){
            private final /* synthetic */ MouseListener val$mouseListener;
            {
                this.val$mouseListener = mouseListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                table.removeDisposeListener((DisposeListener)this);
                table.removeMouseListener(this.val$mouseListener);
            }
        });
    }
}

