/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.widgets;

import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.core.model.IGenericDataModelEventListener;
import com.fusesource.zk.core.reflect.SwtThreadSafeDelegatingInvocationHandler;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractDataModelWidgetView<W extends Widget>
implements IGenericDataModelEventListener,
SwtThreadSafeDelegatingInvocationHandler.IWidgetProvider {
    private final DataModel<?, ?, ?> _Model;
    private IGenericDataModelEventListener _ModelEventListener;
    private final W _Widget;

    public AbstractDataModelWidgetView(DataModel<?, ?, ?> model, W widget) {
        this._Model = model;
        this._Widget = widget;
        this.registerModelEventListener();
        this._Widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractDataModelWidgetView.this.unregisterModelEventListener();
                AbstractDataModelWidgetView.this._Widget.removeDisposeListener((DisposeListener)this);
            }
        });
    }

    @Override
    public void dataModelDataChanged(GenericDataModelEvent event) {
        W widget = this.getWidget();
        if (!widget.isDisposed()) {
            this.updateView();
        }
    }

    @Override
    public void dataModelDataRefreshed(GenericDataModelEvent event) {
        W widget = this.getWidget();
        if (!widget.isDisposed()) {
            this.updateView();
        }
    }

    @Override
    public void dataModelDestroyed(GenericDataModelEvent event) {
        W widget = this.getWidget();
        if (!widget.isDisposed()) {
            widget.dispose();
        }
    }

    public final DataModel<?, ?, ?> getModel() {
        return this._Model;
    }

    public final W getWidget() {
        return this._Widget;
    }

    public abstract void updateView();

    protected void registerModelEventListener() {
        DataModel<?, ?, ?> model = this.getModel();
        if (model == null) {
            return;
        }
        if (this._ModelEventListener == null) {
            this._ModelEventListener = (IGenericDataModelEventListener)SwtThreadSafeDelegatingInvocationHandler.createProxyInstance(this, IGenericDataModelEventListener.class, true);
        }
        model.addGenericEventListener(this._ModelEventListener);
    }

    protected void unregisterModelEventListener() {
        DataModel<?, ?, ?> model = this.getModel();
        if (model != null && this._ModelEventListener != null) {
            model.removeGenericEventListener(this._ModelEventListener);
            this._ModelEventListener = null;
        }
    }
}

