/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.widgets;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class BaseControlContribution
extends ControlContribution {
    private Control _Control;
    private Set<DisposeListener> _DisposeListeners;

    protected BaseControlContribution(String id) {
        super(id);
    }

    public void addControlDisposeListener(DisposeListener disposeListener) {
        Control control = this.getControl();
        if (control != null) {
            if (control.isDisposed()) {
                return;
            }
            control.addDisposeListener(disposeListener);
        } else {
            if (this._DisposeListeners == null) {
                this._DisposeListeners = new LinkedHashSet<DisposeListener>();
            }
            this._DisposeListeners.add(disposeListener);
        }
    }

    public Control getControl() {
        return this._Control;
    }

    public void removeControlDisposeListener(DisposeListener disposeListener) {
        Control control = this.getControl();
        if (control != null) {
            control.removeDisposeListener(disposeListener);
        } else if (this._DisposeListeners != null) {
            this._DisposeListeners.remove(disposeListener);
        }
    }

    protected final Control createControl(Composite parent) {
        this._Control = this.createControlInternal(parent);
        if (this._Control != null && !this._Control.isDisposed() && this._DisposeListeners != null) {
            for (DisposeListener disposeListener : this._DisposeListeners) {
                this._Control.addDisposeListener(disposeListener);
            }
            this._DisposeListeners.clear();
        }
        return this._Control;
    }

    protected abstract Control createControlInternal(Composite var1);
}

