/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.widgets;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableEdit {
    public TableEdit(Table table) {
        this(table, -1);
    }

    public TableEdit(Table table, int columnIndex) {
        this(table, null, columnIndex);
    }

    public TableEdit(Table table, CommitEditRunnable commitEditRunnable) {
        this(table, commitEditRunnable, -1);
    }

    public TableEdit(final Table table, final CommitEditRunnable commitEditRunnable, final int columnIndex) {
        final TableCursor cursor = new TableCursor(table, 0);
        final ControlEditor editor = new ControlEditor((Composite)cursor);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableEdit.this.beginTableEdit(cursor, editor, commitEditRunnable);
            }

            public void widgetSelected(SelectionEvent e) {
                table.setSelection(new TableItem[]{cursor.getRow()});
            }
        });
        cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144 || e.keyCode == 131072 || (e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    cursor.setVisible(false);
                }
            }
        });
        cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableEdit.this.beginTableEdit(cursor, editor, commitEditRunnable);
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                int column = columnIndex >= 0 ? columnIndex : 0;
                TableItem[] selection = table.getSelection();
                TableItem row = selection.length == 0 ? table.getItem(table.getTopIndex()) : selection[0];
                table.showItem(row);
                cursor.setSelection(row, column);
                cursor.setVisible(true);
                cursor.setFocus();
            }
        });
        if (columnIndex >= 0) {
            cursor.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (cursor.getColumn() != columnIndex) {
                        cursor.setSelection(cursor.getRow(), columnIndex);
                    }
                }
            });
        }
    }

    private final void beginTableEdit(final TableCursor cursor, final ControlEditor editor, final CommitEditRunnable commitEditRunnable) {
        final Text text = new Text((Composite)cursor, 0);
        TableItem row = cursor.getRow();
        final int column = cursor.getColumn();
        text.setText(row.getText(column));
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    TableItem row = cursor.getRow();
                    try {
                        TableEdit.this.endTableEdit(cursor, editor, commitEditRunnable, row, column, text.getText());
                    }
                    catch (Exception error) {
                        String title = "Edit Failed";
                        String message = error.getLocalizedMessage();
                        MessageDialog.openError((Shell)cursor.getShell(), (String)title, (String)message);
                        return;
                    }
                    text.dispose();
                }
                if (e.character == '\u001b') {
                    text.dispose();
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                text.dispose();
            }
        });
        editor.setEditor((Control)text);
        text.setFocus();
    }

    protected void endTableEdit(TableCursor tableCursor, ControlEditor editor, CommitEditRunnable commitEditRunnable, TableItem row, int column, String newValue) throws Exception {
        if (commitEditRunnable == null) {
            return;
        }
        commitEditRunnable.setTableCursor(tableCursor);
        commitEditRunnable.setEditor(editor);
        commitEditRunnable.setRow(row);
        commitEditRunnable.setColumn(column);
        commitEditRunnable.setNewValue(newValue);
        BusyIndicator.showWhile((Display)row.getDisplay(), (Runnable)commitEditRunnable);
        Exception error = commitEditRunnable.getError();
        if (error != null) {
            throw error;
        }
    }

    public static abstract class CommitEditRunnable
    implements Runnable {
        private TableCursor _TableCursor;
        private ControlEditor _Editor;
        private TableItem _Row;
        private int _Column;
        private String _NewValue;
        private Exception _Error;

        public TableCursor getTableCursor() {
            return this._TableCursor;
        }

        public void setTableCursor(TableCursor tableCursor) {
            this._TableCursor = tableCursor;
        }

        public ControlEditor getEditor() {
            return this._Editor;
        }

        public void setEditor(ControlEditor editor) {
            this._Editor = editor;
        }

        public TableItem getRow() {
            return this._Row;
        }

        public void setRow(TableItem row) {
            this._Row = row;
        }

        public int getColumn() {
            return this._Column;
        }

        public void setColumn(int column) {
            this._Column = column;
        }

        public String getNewValue() {
            return this._NewValue;
        }

        public void setNewValue(String newValue) {
            this._NewValue = newValue;
        }

        public Exception getError() {
            return this._Error;
        }

        public void setError(Exception error) {
            this._Error = error;
        }
    }
}

