/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.widgets.grid;

import com.fusesource.zk.core.widgets.grid.GridCompositeEvent;
import com.fusesource.zk.core.widgets.grid.GridCompositeStatus;
import com.fusesource.zk.core.widgets.grid.GridTextInput;
import com.fusesource.zk.core.widgets.grid.IGridCompositeEventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class GridComposite
extends Composite {
    public static final Image DEC_ERROR = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    public static final Image DEC_REQUIRED = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage();
    private final Map<String, ControlDecoration> _ControlDecorations;
    private final Map<String, Control> _Controls = new HashMap<String, Control>();
    private GridCompositeStatus _CurrentStatus;
    private CopyOnWriteArrayList<IGridCompositeEventListener> _EventListeners;
    private int _Margin = 8;
    private int _NumColumns = 2;

    public GridComposite(Composite parent) {
        this(parent, 0);
    }

    public GridComposite(Composite parent, int style) {
        super(parent, style);
        this._ControlDecorations = new HashMap<String, ControlDecoration>();
    }

    public final void addGridCompositeEventListener(IGridCompositeEventListener listener) {
        if (this._EventListeners == null) {
            this._EventListeners = new CopyOnWriteArrayList();
        }
        if (!this._EventListeners.contains(listener)) {
            this._EventListeners.add(listener);
            this.modified(null);
        }
    }

    public final Control getControl(String name) {
        if (this._Controls.containsKey(name)) {
            return this._Controls.get(name);
        }
        return null;
    }

    public final GridCompositeStatus getCurrentStatus() {
        return this._CurrentStatus;
    }

    public final int getMargin() {
        return this._Margin;
    }

    public final int getNumColumns() {
        return this._NumColumns;
    }

    public void init() {
        this.setLayout((Layout)this.createLayout());
        this.createContents();
        this.layout(true);
        this.registerChildGridComposites(this.getChildren());
    }

    public final void removeGridCompositeEventListener(IGridCompositeEventListener listener) {
        if (this._EventListeners == null) {
            return;
        }
        if (!this._EventListeners.contains(listener)) {
            return;
        }
        this._EventListeners.remove(listener);
    }

    public final void setMargin(int margin) {
        this._Margin = margin;
    }

    public final void setNumColumns(int numColumns) {
        this._NumColumns = numColumns;
    }

    protected final void addControl(String name, Control control) {
        if (this._Controls.containsKey(name)) {
            throw new IllegalArgumentException("Control '" + name + "' already exists.");
        }
        this._Controls.put(name, control);
    }

    protected final void addControlDecoration(String name, Control control) {
        this.addControlDecoration(name, control, 16512);
    }

    protected final void addControlDecoration(String name, Control control, int style) {
        this.addControlDecoration(name, control, style, this);
    }

    protected final void addControlDecoration(String name, Control control, int style, Composite container) {
        if (this._ControlDecorations.containsKey(name)) {
            throw new IllegalArgumentException("ControlDecoration '" + name + "' already exists.");
        }
        ControlDecoration controlDecoration = new ControlDecoration(control, style, container);
        controlDecoration.setShowHover(true);
        this._ControlDecorations.put(name, controlDecoration);
    }

    protected final void addGridTextInput(GridTextInput textInput) {
        this.addGridTextInput(textInput, 16512);
    }

    protected final void addGridTextInput(final GridTextInput textInput, int controlDecorationStyle) {
        String name = textInput.getName();
        Text text = textInput.getText();
        this.addControl(name, (Control)text);
        this.addControlDecoration(name, (Control)text, controlDecorationStyle, text.getParent());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GridComposite.this.modified(textInput);
            }
        });
        if (textInput.getType().isInteger()) {
            text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    String text = event.text;
                    event.doit = text.length() == 0 || Character.isDigit(text.charAt(0)) && GridTextInput.isValidIntegerText(text);
                }
            });
        }
    }

    protected abstract void createContents();

    protected GridLayout createLayout() {
        int margin;
        GridLayout layout = new GridLayout(this.getNumColumns(), false);
        layout.horizontalSpacing = margin = this.getMargin();
        layout.verticalSpacing = margin;
        layout.marginWidth = margin;
        layout.marginHeight = margin;
        return layout;
    }

    protected final void modified(Object source) {
        for (ControlDecoration controlDecoration : this._ControlDecorations.values()) {
            controlDecoration.hide();
        }
        this._CurrentStatus = this.updateStatus();
        String controlName = this._CurrentStatus.getControlName();
        String message = this._CurrentStatus.getMessage();
        GridCompositeStatus.Type type = this._CurrentStatus.getType();
        if (controlName != null && message != null && type.isError() && this._ControlDecorations.containsKey(controlName)) {
            ControlDecoration controlDecoration = this._ControlDecorations.get(controlName);
            Image image = null;
            if (type == GridCompositeStatus.Type.ERROR_INVALID) {
                image = DEC_ERROR;
            } else if (type == GridCompositeStatus.Type.ERROR_REQUIRED) {
                image = DEC_REQUIRED;
            }
            if (image != null) {
                controlDecoration.setImage(image);
            }
            controlDecoration.setDescriptionText(message);
            controlDecoration.show();
        }
        this.fireModified(this._CurrentStatus);
    }

    protected final void removeControl(String name) {
        this._Controls.remove(name);
    }

    protected final void removeControlDecoration(String name) {
        this._ControlDecorations.remove(name);
    }

    protected GridCompositeStatus updateStatus(Object source) {
        if (source instanceof GridTextInput) {
            return this.updateStatusFromGridTextInput((GridTextInput)source);
        }
        if (source instanceof GridComposite) {
            return ((GridComposite)((Object)source)).getCurrentStatus();
        }
        return GridCompositeStatus.OK_STATUS;
    }

    private void fireModified(GridCompositeStatus status) {
        if (this._EventListeners != null) {
            GridCompositeEvent event = new GridCompositeEvent(this, status);
            for (IGridCompositeEventListener listener : this._EventListeners) {
                listener.modified(event);
            }
        }
    }

    private void registerChildGridComposites(Control[] controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof GridComposite) {
                final GridComposite gridComposite = (GridComposite)control;
                final IGridCompositeEventListener gridCompositeEventListener = new IGridCompositeEventListener(){

                    @Override
                    public void modified(GridCompositeEvent event) {
                        GridComposite.this.modified((Object)gridComposite);
                    }
                };
                gridComposite.addGridCompositeEventListener(gridCompositeEventListener);
                gridComposite.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        gridComposite.removeGridCompositeEventListener(gridCompositeEventListener);
                        gridComposite.removeDisposeListener(this);
                    }
                });
            } else if (control instanceof Composite) {
                this.registerChildGridComposites(((Composite)control).getChildren());
            }
            ++n2;
        }
    }

    private GridCompositeStatus updateStatus() {
        return this.updateStatus(this.getChildren());
    }

    private GridCompositeStatus updateStatus(Control[] controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (this.isVisible() == control.isVisible()) {
                GridCompositeStatus status;
                Object controlData;
                Object controlSource = control;
                if (control instanceof Text && (controlData = control.getData()) instanceof GridTextInput) {
                    controlSource = controlData;
                }
                if ((status = this.updateStatus(controlSource)).getType().isError()) {
                    return status;
                }
                if (control instanceof Composite && (status = this.updateStatus(((Composite)control).getChildren())).getType().isError()) {
                    return status;
                }
            }
            ++n2;
        }
        return GridCompositeStatus.OK_STATUS;
    }

    private GridCompositeStatus updateStatusFromGridTextInput(GridTextInput source) {
        Text textControl = source.getText();
        String name = source.getName();
        GridTextInput.Type inputType = source.getType();
        String text = textControl.getText();
        String defaultValue = source.getDefaultTextValue();
        if (inputType.isValueRequired() && text.trim().length() == 0) {
            String message = defaultValue != null ? String.valueOf(name) + " value must be specified.  Default value is " + defaultValue : String.valueOf(name) + " value must be specified.";
            GridCompositeStatus.Type statusType = GridCompositeStatus.Type.ERROR_REQUIRED;
            return new GridCompositeStatus(name, message, statusType);
        }
        if (inputType.isInteger() && !GridTextInput.isValidIntegerText(text)) {
            String message = defaultValue != null ? String.valueOf(name) + " value must be a positive integer.  Default value is " + defaultValue : String.valueOf(name) + " value must be a positive integer.";
            GridCompositeStatus.Type statusType = GridCompositeStatus.Type.ERROR_INVALID;
            return new GridCompositeStatus(name, message, statusType);
        }
        return GridCompositeStatus.OK_STATUS;
    }
}

