/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.core.widgets.grid;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class GridTextInput {
    public static final GridData GRID_DATA_FILL = new GridData(4, 0x1000000, true, false);
    public static final GridData GRID_DATA_FIXED = new GridData(1, 0x1000000, false, false);
    public static final int STYLE_LABEL = 16384;
    public static final int STYLE_TEXT = 2052;
    private final String _DefaultTextValue;
    private Label _Label;
    private final String _Name;
    private final Text _Text;
    private final Type _Type;

    public static boolean isValidIntegerText(String text) {
        int intValue = -1;
        try {
            intValue = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return intValue >= 0;
    }

    public GridTextInput(Composite parent, Type type, String name, String labelText, int labelStyle, GridData labelLayoutData, String textText, int textStyle, GridData textLayoutData) {
        this._Type = type;
        this._DefaultTextValue = textText;
        if (this._DefaultTextValue != null && this._Type.isInteger() && !GridTextInput.isValidIntegerText(this._DefaultTextValue)) {
            throw new IllegalArgumentException("Invalid integer value: " + this._DefaultTextValue);
        }
        this._Name = name;
        if (labelText != null) {
            this._Label = new Label(parent, labelStyle);
            this._Label.setText(labelText);
            this._Label.setLayoutData((Object)labelLayoutData);
            this._Label.pack();
        }
        this._Text = new Text(parent, textStyle);
        if (textText != null) {
            this._Text.setText(textText);
        }
        this._Text.setLayoutData((Object)textLayoutData);
        if (this._Type.isInteger()) {
            this._Text.setTextLimit(10);
        }
        this._Text.setData((Object)this);
    }

    public GridTextInput(Composite parent, Type type, String name, String labelText, String textText) {
        this(parent, type, name, labelText, 16384, GRID_DATA_FIXED, textText, 2052, GRID_DATA_FILL);
    }

    public GridTextInput(Composite parent, Type type, String name, String labelText, String textText, int textHorizontalSpan) {
        this(parent, type, name, labelText, 16384, GRID_DATA_FIXED, textText, 2052, new GridData(4, 0x1000000, true, false, textHorizontalSpan, 1));
    }

    public String getDefaultTextValue() {
        return this._DefaultTextValue;
    }

    public Label getLabel() {
        return this._Label;
    }

    public String getName() {
        return this._Name;
    }

    public Text getText() {
        return this._Text;
    }

    public Type getType() {
        return this._Type;
    }

    public void setEnabled(boolean enabled) {
        this._Label.setEnabled(enabled);
        this._Text.setEnabled(enabled);
    }

    public static enum Type {
        DEFAULT(0, false, false),
        INTEGER(2, false, true),
        INTEGER_VALUE_REQUIRED(3, true, true),
        VALUE_REQUIRED(1, true, false);

        private final int _Flag;
        private final boolean _Integer;
        private final boolean _ValueRequired;

        private Type(int flag, boolean valueRequired, boolean integer) {
            this._Flag = flag;
            this._ValueRequired = valueRequired;
            this._Integer = integer;
        }

        public int getFlag() {
            return this._Flag;
        }

        public boolean isInteger() {
            return this._Integer;
        }

        public boolean isValueRequired() {
            return this._ValueRequired;
        }
    }
}

