/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds;

import java.util.Dictionary;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudProviderBridge
implements LifecycleListener {
    private static final Logger LOGGGER = LoggerFactory.getLogger(CloudProviderBridge.class);
    private static final String COMPUTE_FILTER = "(service.factoryPid=org.jclouds.compute)";
    private static final String BLOBSTORE_FILTER = "(service.factoryPid=org.jclouds.blobstore)";
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;

    public void onConnected() {
        this.registerProviders(COMPUTE_FILTER);
        this.registerProviders(BLOBSTORE_FILTER);
    }

    public void onDisconnected() {
    }

    public void registerProviders(String filter) {
        try {
            Configuration[] configurations = this.configurationAdmin.listConfigurations(filter);
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    Dictionary properties = configuration.getProperties();
                    if (properties == null) continue;
                    String provider = String.valueOf(properties.get("provider"));
                    String identity = String.valueOf(properties.get("identity"));
                    String credential = String.valueOf(properties.get("credential"));
                    if (provider == null || identity == null || credential == null || !this.getZooKeeper().isConnected() || this.getZooKeeper().exists(ZkPath.CLOUD_PROVIDER.getPath(new String[]{provider})) != null) continue;
                    ZooKeeperUtils.create((IZKClient)this.getZooKeeper(), (String)ZkPath.CLOUD_PROVIDER.getPath(new String[]{provider}));
                    ZooKeeperUtils.set((IZKClient)this.getZooKeeper(), (String)ZkPath.CLOUD_PROVIDER_IDENTIY.getPath(new String[]{provider}), (String)identity);
                    ZooKeeperUtils.set((IZKClient)this.getZooKeeper(), (String)ZkPath.CLOUD_PROVIDER_CREDENTIAL.getPath(new String[]{provider}), (String)credential);
                }
            }
        }
        catch (Exception e) {
            LOGGGER.error("Failed to retrieve compute service information from configuration admin.", (Throwable)e);
        }
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }
}

