/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.commands;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.service.jclouds.internal.CloudUtils;

@Command(name="cloud-provider-add", scope="fabric", description="Registers a cloud provider to the registry.")
public class CloudProviderAdd
extends FabricCommand {
    @Argument(index=0, name="provider", required=true, description="The cloud provider name")
    private String provider;
    @Argument(index=1, name="identity", required=false, description="The cloud identity to use")
    private String identity;
    @Argument(index=2, name="credential", required=true, description="The cloud credential to use")
    private String credential;
    @Option(name="--async-registration", required=false, description="Flag to not wait for the provider registration.")
    private Boolean registerAsync = false;
    @Option(name="--owner", required=false, description="EC2 AMI owner")
    private String owner;
    @Option(name="--option", required=false, multiValued=true, description="Provider specify properties. Example: --option jclouds.regions=us-east-1")
    private String[] options;

    protected Object doExecute() throws Exception {
        Map<String, String> props = CloudUtils.parseProviderOptions(this.options);
        if (this.options != null && this.options.length > 1) {
            for (String option : this.options) {
                if (!option.contains("=")) continue;
                String key = option.substring(0, option.indexOf("="));
                String value = option.substring(option.lastIndexOf("=") + 1);
                props.put(key, value);
            }
        }
        if (!Strings.isNullOrEmpty((String)this.owner)) {
            props.put("owner", this.owner);
        }
        Container current = this.fabricService.getCurrentContainer();
        if (!this.getZooKeeper().isConnected() || !current.isManaged()) {
            CloudUtils.registerProvider(this.getZooKeeper(), this.configurationAdmin, this.provider, this.identity, this.credential, props);
            if (!this.registerAsync.booleanValue()) {
                System.out.println("Waiting for " + this.provider + " service to initialize.");
                CloudUtils.waitForComputeService(this.bundleContext, this.provider);
            }
        }
        return null;
    }
}

