/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.commands;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.jclouds.compute.ComputeService;
import org.jclouds.karaf.core.ComputeProviderListener;

@Command(name="cloud-provider-list", scope="fabric", description="Registers a cloud provider to the registry.")
public class CloudProviderList
extends FabricCommand {
    public static final String PROVIDERFORMAT = "%-24s %-12s %-12s";
    private ComputeProviderListener computeProviderListener;
    private List<ComputeService> computeServices;

    protected Object doExecute() throws Exception {
        Set providers = this.computeProviderListener.getInstalledProviders();
        if (providers != null && !providers.isEmpty()) {
            this.printComputeProviders(providers, this.computeServices, "", System.out);
        } else {
            System.out.print("No providers have been found.");
        }
        return null;
    }

    protected void printComputeProviders(Set<String> providers, List<ComputeService> computeServices, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service registration]"));
        for (String provider : providers) {
            String registrationType;
            block8: {
                boolean registered = false;
                registrationType = "none";
                for (ComputeService computeService : computeServices) {
                    if (!computeService.getContext().getProviderSpecificContext().getId().equals(provider)) continue;
                    registered = true;
                    break;
                }
                if (registered && this.getZooKeeper() != null && this.getZooKeeper().isConnected()) {
                    try {
                        if (this.getZooKeeper().exists(ZkPath.CLOUD_PROVIDER.getPath(new String[]{provider})) == null) {
                            registrationType = "local";
                            break block8;
                        }
                        registrationType = "fabric";
                    }
                    catch (Exception e) {}
                } else if (registered) {
                    registrationType = "local";
                }
            }
            out.println(String.format(PROVIDERFORMAT, provider, "compute", registrationType));
        }
    }

    public ComputeProviderListener getComputeProviderListener() {
        return this.computeProviderListener;
    }

    public void setComputeProviderListener(ComputeProviderListener computeProviderListener) {
        this.computeProviderListener = computeProviderListener;
    }

    public List<ComputeService> getComputeServices() {
        return this.computeServices;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }
}

