/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.osgi.service.cm.Configuration;

@Command(name="cloud-provider-add", scope="fabric", description="Registers a cloud provider to the registry.")
public class CloudProviderRemove
extends FabricCommand {
    private static final String PID_FILTER = "(service.pid=%s*)";
    @Argument(index=0, name="provider", required=true, description="JClouds provider name")
    private String provider;

    protected Object doExecute() throws Exception {
        boolean connected = this.getZooKeeper().isConnected();
        Container current = null;
        if (connected) {
            this.getZooKeeper().deleteWithChildren(ZkPath.CLOUD_PROVIDER.getPath(new String[]{this.provider}));
            current = this.fabricService.getCurrentContainer();
        }
        if (current == null || !current.isManaged()) {
            Configuration[] computeConfigs;
            for (Configuration configuration : computeConfigs = this.findConfigurationByFactoryPid("org.jclouds.compute")) {
                configuration.delete();
            }
        }
        return null;
    }

    private Configuration[] findConfigurationByFactoryPid(String factoryPid) {
        Configuration[] configurations = new Configuration[]{};
        try {
            configurations = this.configurationAdmin.listConfigurations(String.format(PID_FILTER, factoryPid));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configurations;
    }
}

