/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.commands;

import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.CreateContainerBasicOptions;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.api.CreateJCloudsContainerMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerOptions;
import org.fusesource.fabric.api.CreationStateListener;
import org.fusesource.fabric.api.JCloudsInstanceType;
import org.fusesource.fabric.boot.commands.support.ContainerCreateSupport;
import org.fusesource.fabric.internal.PrintStreamCreationStateListener;
import org.fusesource.fabric.service.jclouds.internal.CloudUtils;

@Command(name="container-create-cloud", scope="fabric", description="Creates one or more new containers on the cloud")
public class ContainerCreateCloud
extends ContainerCreateSupport {
    static final String DISPLAY_FORMAT = "%22s %-30s %-30s %-30s ";
    static final String[] OUTPUT_HEADERS = new String[]{"[id]", "[container]", "[public addresses]", "[status]"};
    @Option(name="--provider", required=true, description="The cloud provider name")
    private String providerName;
    @Option(name="--os-family", multiValued=false, required=false, description="OS Family")
    private String osFamily = "ubuntu";
    @Option(name="--os-version", multiValued=false, required=false, description="OS Version")
    private String osVersion;
    @Option(name="--identity", required=false, description="The cloud identity to use")
    private String identity;
    @Option(name="--credential", required=false, description="Credential to login to the cloud")
    private String credential;
    @Option(name="--hardware", required=false, description="Which hardware kind to use")
    private String hardwareId;
    @Option(name="--instanceType", required=false, description="Which kind of instance is required")
    private JCloudsInstanceType instanceType = JCloudsInstanceType.Smallest;
    @Option(name="--image", required=false, description="The image ID to use for the new node(s)")
    private String imageId;
    @Option(name="--location", required=false, description="The location to use to create the new node(s)")
    private String locationId;
    @Option(name="--user", required=false, description="User account to use on the new node(s)")
    private String user;
    @Option(name="--no-admin-access", required=false, description="Disables admin access as it might no be feasible on all images.")
    private boolean disableAdminAccess;
    @Option(name="--public-key-file", required=false, description="Path to the public key file to use for authenticating to the container")
    private String publicKeyFile;
    @Option(name="--owner", description="Optional owner of images; only really used for EC2 and deprecated going forward")
    private String owner;
    @Option(name="--option", required=false, multiValued=true, description="Node specify properties. These options are provider specific. Example: --option withSubnetId=someAwsSubnetId.")
    private String[] options;
    @Option(name="--group", description="Group tag to use on the new node(s)")
    private String group = "fabric";
    @Option(name="--proxy-uri", description="Maven proxy URL to use")
    private URI proxyUri;
    @Argument(index=0, required=true, description="The name of the container to be created. When creating multiple containers it serves as a prefix")
    protected String name;
    @Argument(index=1, required=false, description="The number of containers that should be created")
    protected int number = 1;

    protected Object doExecute() throws Exception {
        this.preCreateContainer(this.name);
        CreateContainerBasicOptions args = ((CreateJCloudsContainerOptions)((CreateJCloudsContainerOptions)((CreateJCloudsContainerOptions)((CreateJCloudsContainerOptions)((CreateJCloudsContainerOptions)((CreateJCloudsContainerOptions)((CreateJCloudsContainerOptions)((CreateJCloudsContainerOptions)CreateContainerOptionsBuilder.jclouds().name(this.name)).resolver(this.resolver)).ensembleServer(this.isEnsembleServer.booleanValue())).credential(this.credential).group(this.group).hardwareId(this.hardwareId).identity(this.identity).osFamily(this.osFamily).osVersion(this.osVersion).imageId(this.imageId).instanceType(this.instanceType).locationId(this.locationId).number(this.number)).nodeOptions(CloudUtils.parseProviderOptions(this.options)).owner(this.owner).adminAccess(!this.disableAdminAccess)).publicKeyFile(this.publicKeyFile).providerName(this.providerName).user(this.user).proxyUri(this.proxyUri != null ? this.proxyUri : this.fabricService.getMavenRepoURI())).zookeeperUrl(this.fabricService.getZookeeperUrl())).jvmOpts(this.jvmOpts)).creationStateListener((CreationStateListener)new PrintStreamCreationStateListener(System.out));
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)args);
        this.displayContainers(metadatas);
        this.postCreateContainers(metadatas);
        return null;
    }

    @Override
    protected void displayContainers(CreateContainerMetadata[] metadatas) {
        System.out.println(String.format(DISPLAY_FORMAT, OUTPUT_HEADERS));
        if (metadatas != null && metadatas.length > 0) {
            for (CreateContainerMetadata ccm : metadatas) {
                CreateJCloudsContainerMetadata metadata = (CreateJCloudsContainerMetadata)ccm;
                String status = "success";
                if (ccm.getFailure() != null) {
                    status = ccm.getFailure().getMessage();
                }
                String nodeId = metadata.getNodeId() != null ? metadata.getNodeId() : "";
                String containerName = metadata.getContainerName() != null ? metadata.getContainerName() : "";
                System.out.println(String.format(DISPLAY_FORMAT, nodeId, containerName, metadata.getPublicAddresses(), status));
            }
        }
    }

    @Override
    protected void preCreateContainer(String name) {
        super.preCreateContainer(name);
        if (this.number < 1 || this.number > 999) {
            throw new IllegalArgumentException("The number of containers must be between 1 and 999.");
        }
        if (this.isEnsembleServer.booleanValue() && this.number > 1) {
            throw new IllegalArgumentException("Can not create a new ZooKeeper ensemble on multiple containers.  Create the containers and then use the fabric:create command instead.");
        }
    }
}

