/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service.jclouds.modules;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.karaf.core.CredentialStore;
import org.jclouds.rest.ConfiguresCredentialStore;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfiguresCredentialStore
public class ZookeeperCredentialStore
extends CredentialStore
implements LifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperCredentialStore.class);
    private IZKClient zooKeeper;
    private Cache<String, Credentials> cache;

    public void init() {
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build();
        this.store = new ZookeeperBacking(this.zooKeeper, this.cache);
    }

    protected void configure() {
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void onConnected() {
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            String s = (String)entry.getKey();
            Credentials credentials = (Credentials)entry.getValue();
            this.store.put(s, credentials);
        }
    }

    public void onDisconnected() {
    }

    private static String normalizeKey(Object key) {
        String result = String.valueOf(key);
        return result.replaceAll("node#", "").replaceAll("#", "");
    }

    private static class CredentialsEntry
    implements Map.Entry<String, Credentials> {
        private String key;
        private IZKClient zookeeper;

        private CredentialsEntry(IZKClient zookeeper, String key) {
            this.zookeeper = zookeeper;
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Credentials getValue() {
            LoginCredentials credentials = null;
            if (this.zookeeper.isConnected()) {
                try {
                    String identity = this.zookeeper.getStringData(ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(this.key)}));
                    String credential = this.zookeeper.getStringData(ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(this.key)}));
                    credentials = LoginCredentials.fromCredentials((Credentials)new Credentials(identity, credential));
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to read jclouds credentials from zookeeper due to {}.", (Object)e.getMessage());
                }
            }
            return credentials;
        }

        @Override
        public Credentials setValue(Credentials credentials) {
            if (this.zookeeper.isConnected()) {
                try {
                    ZooKeeperUtils.set((IZKClient)this.zookeeper, (String)ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(this.key)}), (String)credentials.identity);
                    ZooKeeperUtils.set((IZKClient)this.zookeeper, (String)ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(this.key)}), (String)credentials.credential);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to store jclouds credentials to zookeeper.", (Throwable)e);
                }
            }
            return credentials;
        }
    }

    private class ZookeeperBacking
    implements Map<String, Credentials> {
        private final IZKClient zookeeper;
        private final Cache<String, Credentials> cache;

        private ZookeeperBacking(IZKClient zookeeper, Cache<String, Credentials> cache) {
            this.zookeeper = zookeeper;
            this.cache = cache;
        }

        @Override
        public int size() {
            int size = 0;
            if (this.zookeeper.isConnected()) {
                try {
                    if (this.zookeeper.exists(ZkPath.CLOUD_NODES.getPath(new String[0])) != null) {
                        size = this.zookeeper.getChildren(ZkPath.CLOUD_NODES.getPath(new String[0])).size();
                    }
                }
                catch (Exception exception) {}
            } else {
                size = (int)this.cache.size();
            }
            return size;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object o) {
            boolean result = this.cache.asMap().containsKey(o);
            if (!result && this.zookeeper.isConnected()) {
                try {
                    result = this.zookeeper.exists(ZkPath.CLOUD_NODE.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(o)})) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public boolean containsValue(Object o) {
            return false;
        }

        @Override
        public Credentials get(Object o) {
            Credentials credentials = (Credentials)this.cache.asMap().get(o);
            if (credentials == null && this.zookeeper.isConnected()) {
                try {
                    String identity = this.zookeeper.getStringData(ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(o)}));
                    String credential = this.zookeeper.getStringData(ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(o)}));
                    credentials = LoginCredentials.fromCredentials((Credentials)new Credentials(identity, credential));
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to read jclouds credentials from zookeeper due to {}.", (Object)e.getMessage());
                }
            }
            return credentials;
        }

        @Override
        public Credentials put(String s, Credentials credentials) {
            this.cache.put((Object)s, (Object)credentials);
            if (this.zookeeper.isConnected()) {
                try {
                    ZooKeeperUtils.set((IZKClient)this.zookeeper, (String)ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(s)}), (String)credentials.identity);
                    ZooKeeperUtils.set((IZKClient)this.zookeeper, (String)ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{ZookeeperCredentialStore.normalizeKey(s)}), (String)credentials.credential);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to store jclouds credentials to zookeeper.", (Throwable)e);
                }
            }
            return credentials;
        }

        @Override
        public Credentials remove(Object o) {
            Credentials credentials = (Credentials)this.cache.asMap().remove(o);
            if (this.zookeeper.isConnected()) {
                try {
                    if (credentials == null) {
                        credentials = this.get(o);
                    }
                    String normalizedKey = ZookeeperCredentialStore.normalizeKey(o);
                    if (this.zookeeper.exists(ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{normalizedKey})) != null) {
                        this.zookeeper.deleteWithChildren(ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{normalizedKey}));
                    }
                    if (this.zookeeper.exists(ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{normalizedKey})) != null) {
                        this.zookeeper.deleteWithChildren(ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{normalizedKey}));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to remove jclouds credentials to zookeeper.", (Throwable)e);
                }
            }
            return credentials;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Credentials> map) {
            for (Map.Entry<? extends String, ? extends Credentials> entry : map.entrySet()) {
                String s = entry.getKey();
                Credentials credential = entry.getValue();
                this.put(s, credential);
            }
        }

        @Override
        public void clear() {
            this.cache.cleanUp();
            if (this.zookeeper.isConnected()) {
                try {
                    for (String nodeId : this.keySet()) {
                        if (this.zookeeper.exists(ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{nodeId})) != null) {
                            this.zookeeper.deleteWithChildren(ZkPath.CLOUD_NODE_IDENTITY.getPath(new String[]{nodeId}));
                        }
                        if (this.zookeeper.exists(ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{nodeId})) == null) continue;
                        this.zookeeper.deleteWithChildren(ZkPath.CLOUD_NODE_CREDENTIAL.getPath(new String[]{nodeId}));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to clear zookeeper jclouds credentials store.", (Throwable)e);
                }
            }
        }

        @Override
        public Set<String> keySet() {
            Set<Object> keys = new HashSet();
            if (this.zookeeper.isConnected()) {
                try {
                    keys = new HashSet(this.zookeeper.getChildren(ZkPath.CLOUD_NODE.getPath(new String[0])));
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to read from zookeeper jclouds credentials store.", (Throwable)e);
                }
            } else {
                keys = this.cache.asMap().keySet();
            }
            return keys;
        }

        @Override
        public Collection<Credentials> values() {
            LinkedList<Credentials> credentialsList = new LinkedList<Credentials>();
            for (String key : this.keySet()) {
                credentialsList.add(this.get(key));
            }
            return credentialsList;
        }

        @Override
        public Set<Map.Entry<String, Credentials>> entrySet() {
            HashSet<Map.Entry<String, Credentials>> entrySet = new HashSet<Map.Entry<String, Credentials>>();
            if (ZookeeperCredentialStore.this.zooKeeper.isConnected()) {
                for (String key : this.keySet()) {
                    entrySet.add(new CredentialsEntry(this.zookeeper, key));
                }
            } else {
                entrySet.addAll(this.cache.asMap().entrySet());
            }
            return entrySet;
        }
    }
}

