/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class $Finalizer
implements Runnable {
    private static final Logger logger = Logger.getLogger($Finalizer.class.getName());
    private static final String FINALIZABLE_REFERENCE = "com.google.inject.internal.util.$FinalizableReference";
    private static final String EXECUTOR_CLASS_NAME;
    private final WeakReference<Class<?>> finalizableReferenceClassReference;
    private final PhantomReference<Object> frqReference;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();

    public static ReferenceQueue<Object> startFinalizer(Class<?> finalizableReferenceClass, Object frq) {
        if (!finalizableReferenceClass.getName().equals(FINALIZABLE_REFERENCE)) {
            throw new IllegalArgumentException("Expected com.google.inject.internal.util.FinalizableReference.");
        }
        if ("NONE".equalsIgnoreCase(EXECUTOR_CLASS_NAME)) {
            return null;
        }
        $Finalizer finalizer = new $Finalizer(finalizableReferenceClass, frq);
        try {
            if (EXECUTOR_CLASS_NAME == null || EXECUTOR_CLASS_NAME.length() == 0) {
                Thread thread = new Thread((Runnable)finalizer, $Finalizer.class.getName());
                thread.setDaemon(true);
                thread.start();
            } else {
                Class<?> executorClass;
                try {
                    executorClass = Thread.currentThread().getContextClassLoader().loadClass(EXECUTOR_CLASS_NAME);
                }
                catch (Throwable ignore) {
                    executorClass = Class.forName(EXECUTOR_CLASS_NAME);
                }
                ((Executor)executorClass.newInstance()).execute(finalizer);
            }
            return finalizer.queue;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Cannot start Finalizer thread.", t);
            return null;
        }
    }

    private $Finalizer(Class<?> finalizableReferenceClass, Object frq) {
        this.finalizableReferenceClassReference = new WeakReference(finalizableReferenceClass);
        this.frqReference = new PhantomReference<Object>(frq, this.queue);
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        this.cleanUp(this.queue.remove());
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (ShutDown shutDown) {
            return;
        }
    }

    private void cleanUp(Reference<?> reference) throws ShutDown {
        Method finalizeReferentMethod = this.getFinalizeReferentMethod();
        do {
            reference.clear();
            if (reference == this.frqReference) {
                throw new ShutDown();
            }
            try {
                finalizeReferentMethod.invoke(reference, new Object[0]);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Error cleaning up after reference.", t);
            }
        } while ((reference = this.queue.poll()) != null);
    }

    private Method getFinalizeReferentMethod() throws ShutDown {
        Class finalizableReferenceClass = (Class)this.finalizableReferenceClassReference.get();
        if (finalizableReferenceClass == null) {
            throw new ShutDown();
        }
        try {
            return finalizableReferenceClass.getMethod("finalizeReferent", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        String executorClassName = null;
        try {
            executorClassName = System.getProperty("guice.executor.class");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EXECUTOR_CLASS_NAME = executorClassName;
    }

    private static class ShutDown
    extends Exception {
        private ShutDown() {
        }
    }
}

