/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.logback.configuration;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.logback.configuration.LogHelper;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.SubstituteLoggerFactory;

public class LogPlugin
extends Plugin {
    private static final String PLUGIN_ID = "org.eclipse.m2e.logback.configuration";
    private static final String RESOURCES_PLUGIN_ID = "org.eclipse.core.resources";
    public static final String PROPERTY_LOG_DIRECTORY = "org.eclipse.m2e.log.dir";
    private BundleContext bundleContext;
    private boolean isConfigured;
    private Timer timer = new Timer("logback configurator timer");
    private TimerTask timerTask = new TimerTask(){

        public void run() {
            if (!LogPlugin.this.isStateLocationInitialized()) {
                return;
            }
            LogPlugin.this.timer.cancel();
            LogPlugin.this.configureLogback();
        }
    };

    private boolean isStateLocationInitialized() {
        if (!Platform.isRunning()) {
            return false;
        }
        Bundle resourcesBundle = Platform.getBundle((String)RESOURCES_PLUGIN_ID);
        if (resourcesBundle == null) {
            return false;
        }
        return resourcesBundle.getState() == 32;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        if (System.getProperty("logback.configurationFile") != null) {
            LogPlugin.systemOut("logback.configurationFile=" + System.getProperty("logback.configurationFile"));
            return;
        }
        if (!this.isStateLocationInitialized()) {
            LogPlugin.systemOut("The org.eclipse.m2e.logback.configuration bundle was activated before the state location was initialized.  Will retry after the state location is initialized.");
            this.timer.schedule(this.timerTask, 0L, 50L);
        } else {
            this.configureLogback();
        }
    }

    private static void systemOut(String message) {
        if ("true".equals(FrameworkProperties.getProperty((String)"eclipse.consoleLog"))) {
            System.out.println("org.eclipse.m2e.logback.configuration: " + message);
        }
    }

    private static void systemErr(String message) {
        System.err.println("org.eclipse.m2e.logback.configuration: " + message);
    }

    private synchronized void configureLogback() {
        if (this.isConfigured) {
            LogPlugin.systemOut("Logback was configured already");
            return;
        }
        try {
            File stateDir = this.getStateLocation().toFile();
            File configFile = new File(stateDir, "logback." + this.bundleContext.getBundle().getVersion().toString() + ".xml");
            LogPlugin.systemOut("Logback config file: " + configFile.getAbsolutePath());
            if (!configFile.isFile()) {
                InputStream is = this.bundleContext.getBundle().getEntry("defaultLogbackConfiguration/logback.xml").openStream();
                try {
                    configFile.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(configFile);
                    try {
                        int n;
                        byte[] buffer = new byte[4096];
                        while ((n = is.read(buffer)) >= 0) {
                            fos.write(buffer, 0, n);
                        }
                    }
                    finally {
                        fos.close();
                    }
                }
                finally {
                    is.close();
                }
            }
            if (System.getProperty(PROPERTY_LOG_DIRECTORY, "").length() <= 0) {
                System.setProperty(PROPERTY_LOG_DIRECTORY, stateDir.getAbsolutePath());
            }
            LogPlugin.loadConfiguration(configFile.toURL());
            this.isConfigured = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().log((IStatus)new Status(2, PLUGIN_ID, "Exception while setting up logging:" + e.getMessage(), (Throwable)e));
            return;
        }
    }

    public static void loadConfiguration(URL configFile) throws JoranException {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        int i = 0;
        while (loggerFactory instanceof SubstituteLoggerFactory && i < 100) {
            LogPlugin.systemOut("SLF4J logger factory class: " + loggerFactory.getClass().getName());
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
            loggerFactory = LoggerFactory.getILoggerFactory();
        }
        if (!(loggerFactory instanceof LoggerContext)) {
            if (loggerFactory == null) {
                LogPlugin.systemErr("SLF4J logger factory is null");
                return;
            }
            LogPlugin.systemErr("SLF4J logger factory is not an instance of LoggerContext: " + loggerFactory.getClass().getName());
            return;
        }
        LogPlugin.systemOut("Initializing logback");
        LoggerContext lc = (LoggerContext)loggerFactory;
        lc.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        configurator.doConfigure(configFile);
        LogPlugin.systemOut("eclipse.consoleLog=" + FrameworkProperties.getProperty((String)"eclipse.consoleLog"));
        boolean consoleLog = "true".equals(FrameworkProperties.getProperty((String)"eclipse.consoleLog"));
        if (consoleLog) {
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
        }
        LogHelper.logJavaProperties(LoggerFactory.getLogger(LogPlugin.class));
    }
}

