/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.g2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.birt.chart.device.DisplayAdapter;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.device.util.ChartTextLayout;
import org.eclipse.birt.chart.device.util.ChartTextMetrics;
import org.eclipse.birt.chart.device.util.ITextLayoutFactory;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class G2dDisplayServerBase
extends DisplayAdapter
implements ITextLayoutFactory {
    protected Graphics2D _g2d;
    protected int iDpiResolution = 0;
    private static Map<String, BufferedImage> imageCache = new HashMap<String, BufferedImage>();
    private static Map<BufferedImage, Size> sizeCache = new HashMap<BufferedImage, Size>();

    public Object createFont(FontDefinition fd) {
        Map fontAttribs = ChartUtil.newHashMap();
        fontAttribs.put(TextAttribute.FAMILY, fd.getName());
        fontAttribs.put(TextAttribute.SIZE, new Float((double)(fd.getSize() * (float)this.getDpiResolution()) / 72.0));
        if (fd.isItalic()) {
            fontAttribs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (fd.isBold()) {
            fontAttribs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (fd.isUnderline()) {
            fontAttribs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (fd.isStrikethrough()) {
            fontAttribs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return new Font(fontAttribs);
    }

    public final Object getColor(ColorDefinition cd) {
        return new Color(cd.getRed(), cd.getGreen(), cd.getBlue(), cd.getTransparency());
    }

    public int getDpiResolution() {
        if (this.iDpiResolution <= 0) {
            return super.getDpiResolution();
        }
        return this.iDpiResolution;
    }

    public void setDpiResolution(int dpi) {
        this.iDpiResolution = dpi;
    }

    public void setGraphicsContext(Object graphicContext) {
        this._g2d = (Graphics2D)graphicContext;
    }

    public ITextMetrics getTextMetrics(Label la, boolean autoReuse) {
        ChartTextMetrics tm = new ChartTextMetrics(this, la, autoReuse);
        return tm;
    }

    public Object loadImage(URL url) throws ChartException {
        String sUrl = url.toString();
        BufferedImage image = imageCache.get(sUrl);
        if (image == null) {
            URL urlFound = this.findResource(url);
            try {
                image = ImageIO.read(urlFound);
                imageCache.put(sUrl, image);
            }
            catch (IOException e) {
                throw new ChartException("org.eclipse.birt.chart.device.extension", 4, (Throwable)e);
            }
        }
        return image;
    }

    public Size getSize(Object oImage) {
        BufferedImage image;
        Size size = null;
        if (oImage instanceof BufferedImage && (size = sizeCache.get(image = (BufferedImage)oImage)) == null) {
            size = SizeImpl.create((double)image.getWidth(), (double)image.getHeight());
            sizeCache.put(image, size);
        }
        return size;
    }

    @Override
    public ChartTextLayout createTextLayout(String value, Map<? extends AttributedCharacterIterator.Attribute, ?> fontAttributes, FontRenderContext frc) {
        return new ChartTextLayout(value, fontAttributes, frc);
    }
}

