/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.OpenMavenConsoleAction;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateConfigurationJob
extends WorkspaceJob {
    private static final Logger log = LoggerFactory.getLogger(UpdateConfigurationJob.class);
    private final IProject[] projects;
    private final boolean offline;
    private final boolean forceUpdate;

    public UpdateConfigurationJob(IProject[] projects) {
        this(projects, MavenPlugin.getMavenConfiguration().isOffline(), false);
    }

    public UpdateConfigurationJob(IProject[] projects, boolean offline, boolean forceUpdate) {
        super(Messages.UpdateSourcesAction_job_update_conf);
        this.projects = projects;
        this.offline = offline;
        this.forceUpdate = forceUpdate;
        this.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
        this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)new OpenMavenConsoleAction());
        monitor.beginTask(this.getName(), this.projects.length);
        long l1 = System.currentTimeMillis();
        log.info("Update started");
        IStatus status = null;
        HashMap<String, Throwable> updateErrors = new HashMap<String, Throwable>();
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.subTask(project.getName());
            IMavenProjectFacade projectFacade = MavenPlugin.getMavenProjectRegistry().create(project, monitor);
            if (projectFacade != null) {
                try {
                    MavenUpdateRequest request = new MavenUpdateRequest(project, this.offline, this.forceUpdate);
                    configurationManager.updateProjectConfiguration(request, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException ex) {
                    if (status == null) {
                        status = new MultiStatus("org.eclipse.m2e.core", 4, Messages.UpdateSourcesAction_error_cannot_update, null);
                    }
                    status.add(ex.getStatus());
                    updateErrors.put(project.getName(), ex);
                }
                catch (IllegalArgumentException e) {
                    status = new MultiStatus("org.eclipse.m2e.core", 4, Messages.UpdateSourcesAction_error_cannot_update, null);
                    updateErrors.put(project.getName(), e);
                }
            }
            ++n2;
        }
        if (updateErrors.size() > 0) {
            this.handleErrors(updateErrors);
        }
        long l2 = System.currentTimeMillis();
        log.info(NLS.bind((String)"Update completed: {0} sec", (Object)((l2 - l1) / 1000L)));
        return status != null ? status : Status.OK_STATUS;
    }

    private void handleErrors(final Map<String, Throwable> updateErrors) {
        final Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    M2EUIUtils.showErrorsForProjectsDialog(display.getActiveShell(), Messages.UpdateSourcesAction_error_title, Messages.UpdateSourcesAction_error_message, updateErrors);
                }
            });
        }
    }
}

