/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.MavenActionSupport;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddDependencyAction
extends MavenActionSupport
implements IWorkbenchWindowActionDelegate {
    private static final Logger log = LoggerFactory.getLogger(AddDependencyAction.class);
    public static final String ID = "org.eclipse.m2e.addDependencyAction";

    public void run(IAction action) {
        IndexedArtifactFile indexedArtifactFile;
        MavenRepositorySearchDialog dialog;
        IMavenProjectFacade facade;
        IFile file = this.getPomFileFromPomEditorOrViewSelection();
        if (file == null) {
            return;
        }
        MavenProject mp = null;
        IProject prj = file.getProject();
        if (prj != null && "pom.xml".equals(file.getProjectRelativePath().toString()) && (facade = MavenPlugin.getMavenProjectRegistry().getProject(prj)) != null) {
            mp = facade.getMavenProject();
        }
        if ((dialog = MavenRepositorySearchDialog.createSearchDependencyDialog(this.getShell(), Messages.AddDependencyAction_searchDialog_title, mp, prj, false)).open() == 0 && (indexedArtifactFile = (IndexedArtifactFile)dialog.getFirstResult()) != null) {
            try {
                final Dependency dependency = indexedArtifactFile.getDependency();
                String selectedScope = dialog.getSelectedScope();
                dependency.setScope(selectedScope);
                if (indexedArtifactFile.version == null) {
                    dependency.setVersion(null);
                }
                PomEdits.performOnDOMDocument(new PomEdits.OperationTuple(file, new PomEdits.Operation(){

                    public void process(Document document) {
                        Element depsEl = PomEdits.getChild(document.getDocumentElement(), "dependencies");
                        Element dep = PomEdits.findChild(depsEl, "dependency", PomEdits.childEquals("groupId", dependency.getGroupId()), PomEdits.childEquals("artifactId", dependency.getArtifactId()));
                        if (dep == null) {
                            dep = PomHelper.createDependency(depsEl, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
                        } else if (dependency.getVersion() != null) {
                            PomEdits.setText(PomEdits.getChild(dep, "version"), dependency.getVersion());
                        }
                        if (dependency.getType() != null && !"jar".equals(dependency.getType()) && !"null".equals(dependency.getType())) {
                            PomEdits.setText(PomEdits.getChild(dep, "type"), dependency.getType());
                        }
                        if (dependency.getClassifier() != null) {
                            PomEdits.setText(PomEdits.getChild(dep, "classifier"), dependency.getClassifier());
                        }
                        if (dependency.getScope() != null && !"compile".equals(dependency.getScope())) {
                            PomEdits.setText(PomEdits.getChild(dep, "scope"), dependency.getScope());
                        }
                    }
                }));
            }
            catch (Exception ex) {
                String msg = NLS.bind((String)Messages.AddDependencyAction_error_msg, (Object)file);
                log.error(msg, (Throwable)ex);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AddDependencyAction_error_title, (String)msg);
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

