/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.m2e.core.ui.internal.actions.MavenActionSupport;
import org.eclipse.m2e.core.ui.internal.actions.UpdateDependenciesAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MavenProjectActionSupport
extends MavenActionSupport
implements IWorkbenchWindowActionDelegate {
    private static final Logger log = LoggerFactory.getLogger(UpdateDependenciesAction.class);

    protected IProject[] getProjects() {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        if (this.selection != null) {
            for (Object o : this.selection) {
                if (o instanceof IProject) {
                    projectList.add((IProject)o);
                    continue;
                }
                if (!(o instanceof IWorkingSet)) continue;
                IWorkingSet workingSet = (IWorkingSet)o;
                IAdaptable[] iAdaptableArray = workingSet.getElements();
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable adaptable = iAdaptableArray[n2];
                    IProject project = (IProject)adaptable.getAdapter(IProject.class);
                    try {
                        if (project != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                            projectList.add(project);
                        }
                    }
                    catch (CoreException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                    ++n2;
                }
            }
        }
        if (projectList.isEmpty()) {
            return ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

