/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.search.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.internal.index.IIndex;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.MatchTyped;
import org.eclipse.m2e.core.internal.index.MatchTypedStringSearchExpression;
import org.eclipse.m2e.core.internal.index.SearchExpression;
import org.eclipse.m2e.core.ui.internal.search.util.ArtifactInfo;
import org.eclipse.m2e.core.ui.internal.search.util.Packaging;
import org.eclipse.m2e.core.ui.internal.search.util.SearchEngine;
import org.eclipse.m2e.core.ui.internal.search.util.SearchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexSearchEngine
implements SearchEngine {
    private final IIndex index;

    public IndexSearchEngine(IIndex index) {
        this.index = index;
    }

    protected boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    @Override
    public Collection<String> findArtifactIds(String groupId, String searchExpression, Packaging packaging, ArtifactInfo containingArtifact) {
        ArrayList<MatchTypedStringSearchExpression> groupIdSearchExpressions = new ArrayList<MatchTypedStringSearchExpression>();
        if (this.isBlank(groupId)) {
            groupIdSearchExpressions.add(new MatchTypedStringSearchExpression("org.apache.maven.plugins", MatchTyped.MatchType.EXACT));
            groupIdSearchExpressions.add(new MatchTypedStringSearchExpression("org.codehaus.mojo", MatchTyped.MatchType.EXACT));
        } else {
            groupIdSearchExpressions.add(new MatchTypedStringSearchExpression(groupId, MatchTyped.MatchType.EXACT));
        }
        try {
            TreeSet<String> ids = new TreeSet<String>();
            for (IndexedArtifact artifact : this.index.find(groupIdSearchExpressions, null, null, packaging.toSearchExpression() == null ? null : Collections.singleton(packaging.toSearchExpression()))) {
                ids.add(artifact.getArtifactId());
            }
            return this.subSet(ids, searchExpression);
        }
        catch (CoreException ex) {
            throw new SearchException(ex.getMessage(), ex.getStatus().getException());
        }
    }

    @Override
    public Collection<String> findClassifiers(String groupId, String artifactId, String version, String prefix, Packaging packaging) {
        try {
            Collection values = this.index.find((SearchExpression)new MatchTypedStringSearchExpression(groupId, MatchTyped.MatchType.EXACT), (SearchExpression)new MatchTypedStringSearchExpression(artifactId, MatchTyped.MatchType.EXACT), null, packaging.toSearchExpression());
            if (values.isEmpty()) {
                return Collections.emptySet();
            }
            TreeSet<String> ids = new TreeSet<String>();
            Set files = ((IndexedArtifact)values.iterator().next()).getFiles();
            for (IndexedArtifactFile artifactFile : files) {
                if (artifactFile.classifier == null) continue;
                ids.add(artifactFile.classifier);
            }
            return this.subSet(ids, prefix);
        }
        catch (CoreException ex) {
            throw new SearchException(ex.getMessage(), ex.getStatus().getException());
        }
    }

    @Override
    public Collection<String> findGroupIds(String searchExpression, Packaging packaging, ArtifactInfo containingArtifact) {
        try {
            TreeSet<String> ids = new TreeSet<String>();
            MatchTypedStringSearchExpression groupSearchExpression = this.isBlank(searchExpression) ? null : new MatchTypedStringSearchExpression(searchExpression, MatchTyped.MatchType.PARTIAL);
            for (IndexedArtifact artifact : this.index.find((SearchExpression)groupSearchExpression, null, null, packaging.toSearchExpression())) {
                ids.add(artifact.getGroupId());
            }
            return this.subSet(ids, searchExpression);
        }
        catch (CoreException ex) {
            throw new SearchException(ex.getMessage(), ex.getStatus().getException());
        }
    }

    @Override
    public Collection<String> findTypes(String groupId, String artifactId, String version, String prefix, Packaging packaging) {
        try {
            Collection values = this.index.find((SearchExpression)new MatchTypedStringSearchExpression(groupId, MatchTyped.MatchType.EXACT), (SearchExpression)new MatchTypedStringSearchExpression(artifactId, MatchTyped.MatchType.EXACT), null, packaging.toSearchExpression());
            if (values.isEmpty()) {
                return Collections.emptySet();
            }
            TreeSet<String> ids = new TreeSet<String>();
            Set files = ((IndexedArtifact)values.iterator().next()).getFiles();
            for (IndexedArtifactFile artifactFile : files) {
                if (artifactFile.type == null) continue;
                ids.add(artifactFile.type);
            }
            return this.subSet(ids, prefix);
        }
        catch (CoreException ex) {
            throw new SearchException(ex.getMessage(), ex.getStatus().getException());
        }
    }

    @Override
    public Collection<String> findVersions(String groupId, String artifactId, String searchExpression, Packaging packaging) {
        try {
            Collection values = this.index.find((SearchExpression)new MatchTypedStringSearchExpression(groupId, MatchTyped.MatchType.EXACT), (SearchExpression)new MatchTypedStringSearchExpression(artifactId, MatchTyped.MatchType.EXACT), null, packaging.toSearchExpression());
            if (values.isEmpty()) {
                return Collections.emptySet();
            }
            TreeSet<String> ids = new TreeSet<String>();
            Set files = ((IndexedArtifact)values.iterator().next()).getFiles();
            for (IndexedArtifactFile artifactFile : files) {
                ids.add(artifactFile.version);
            }
            Collection<String> result = this.subSet(ids, searchExpression);
            TreeSet<ComparableVersion> versions = new TreeSet<ComparableVersion>();
            for (String version : result) {
                versions.add(new ComparableVersion(version));
            }
            result = null;
            ArrayList<String> sorted = new ArrayList<String>(versions.size());
            for (ComparableVersion version : versions) {
                sorted.add(version.toString());
            }
            versions = null;
            Collections.reverse(sorted);
            return sorted;
        }
        catch (CoreException ex) {
            throw new SearchException(ex.getMessage(), ex.getStatus().getException());
        }
    }

    private Collection<String> subSet(TreeSet<String> ids, String searchExpression) {
        if (searchExpression == null || searchExpression.length() == 0) {
            return ids;
        }
        int n = searchExpression.length();
        return ids.subSet(searchExpression, String.valueOf(searchExpression.substring(0, n - 1)) + (char)(searchExpression.charAt(n - 1) + '\u0001'));
    }
}

