/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.util;

import java.util.LinkedList;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentGatherer {
    private MavenProject mavenProject;
    private IMavenProjectFacade projectFacade;

    public ParentGatherer(MavenProject leafProject, IMavenProjectFacade facade) {
        this.mavenProject = leafProject;
        this.projectFacade = facade;
    }

    public LinkedList<MavenProject> getParentHierarchy(IProgressMonitor monitor) throws CoreException {
        LinkedList<MavenProject> hierarchy = new LinkedList<MavenProject>();
        IMaven maven = MavenPlugin.getMaven();
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        maven.detachFromSession(this.mavenProject);
        hierarchy.add(this.mavenProject);
        MavenProject project = this.mavenProject;
        while (project.getModel().getParent() != null) {
            if (monitor.isCanceled()) {
                return null;
            }
            MavenExecutionRequest request = projectManager.createExecutionRequest(this.projectFacade, monitor);
            project = maven.resolveParentProject(request, project, monitor);
            hierarchy.add(project);
        }
        return hierarchy;
    }
}

