/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.views.nodes.IArtifactNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.swt.graphics.Image;

public class IndexedArtifactFileNode
extends PlatformObject
implements IMavenRepositoryNode,
IArtifactNode,
IAdaptable {
    private IndexedArtifactFile artifactFile;

    public IndexedArtifactFileNode(IndexedArtifactFile artifactFile) {
        this.artifactFile = artifactFile;
    }

    public IndexedArtifactFile getIndexedArtifactFile() {
        return this.artifactFile;
    }

    public Object[] getChildren() {
        return null;
    }

    public String getName() {
        String label = this.artifactFile.artifact;
        if (this.artifactFile.classifier != null) {
            label = String.valueOf(label) + " : " + this.artifactFile.classifier;
        }
        if (this.artifactFile.version != null) {
            label = String.valueOf(label) + " : " + this.artifactFile.version;
        }
        return label;
    }

    public boolean hasChildren() {
        return false;
    }

    public Image getImage() {
        if (this.artifactFile.sourcesExists == 1) {
            return MavenImages.IMG_VERSION_SRC;
        }
        return MavenImages.IMG_VERSION;
    }

    public String getDocumentKey() {
        return NexusIndexManager.getDocumentKey((ArtifactKey)this.artifactFile.getArtifactKey());
    }

    public boolean isUpdating() {
        return false;
    }

    public static class AdapterFactory
    implements IAdapterFactory {
        private static final Class[] ADAPTERS = new Class[]{ArtifactKey.class, IndexedArtifactFile.class};

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (adaptableObject instanceof IndexedArtifactFileNode) {
                IndexedArtifactFileNode node = (IndexedArtifactFileNode)adaptableObject;
                IndexedArtifactFile artifactFile = node.artifactFile;
                if (ArtifactKey.class.equals((Object)adapterType)) {
                    return new ArtifactKey(artifactFile.group, artifactFile.artifact, artifactFile.version, artifactFile.classifier);
                }
                if (IndexedArtifactFile.class.equals((Object)adapterType)) {
                    return artifactFile;
                }
            }
            return null;
        }

        public Class[] getAdapterList() {
            return ADAPTERS;
        }
    }
}

