/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import org.eclipse.m2e.core.internal.index.nexus.NexusIndex;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.views.nodes.AbstractIndexedRepositoryNode;

public class RepositoryNode
extends AbstractIndexedRepositoryNode {
    private final IRepository repository;

    public RepositoryNode(NexusIndex index) {
        super(index);
        this.repository = index.getRepository();
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.repository.getId());
        sb.append(" (").append(this.repository.getUrl()).append(")");
        if (this.repository.getMirrorOf() != null) {
            sb.append(" [mirrorOf=").append(this.repository.getMirrorOf()).append("]");
        }
        if (this.repository.getMirrorId() != null) {
            sb.append(" [mirrored by ").append(this.repository.getMirrorId()).append("]");
        }
        if (this.isUpdating()) {
            sb.append(Messages.RepositoryNode_updating);
        }
        return sb.toString();
    }

    public String getRepositoryUrl() {
        return this.repository.getUrl();
    }

    public String getRepoName() {
        return this.repository.toString();
    }
}

