/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ILifecycleMappingRequirement;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscovery;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.IMavenDiscoveryProposal;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.ProjectLifecycleMappingConfiguration;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.UpdateConfigurationJob;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.editing.LifecycleMappingOperation;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.lifecyclemapping.ILifecycleMappingLabelProvider;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractCreateMavenProjectsOperation;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenProjectWizard;
import org.eclipse.m2e.core.ui.internal.wizards.IMavenDiscoveryUI;
import org.eclipse.m2e.core.ui.internal.wizards.LifecycleMappingPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenImportWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenImportWizard
extends AbstractMavenProjectWizard
implements IImportWizard {
    private static final Logger LOG = LoggerFactory.getLogger(MavenImportWizard.class);
    private MavenImportWizardPage page;
    private LifecycleMappingPage lifecycleMappingPage;
    private List<String> locations;
    private boolean showLocation = true;
    private boolean initialized = false;
    private LifecycleMappingConfiguration mappingConfiguration;

    public MavenImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.MavenImportWizard_title);
    }

    public MavenImportWizard(ProjectImportConfiguration importConfiguration, List<String> locations) {
        this();
        this.locations = locations;
        this.showLocation = false;
    }

    public MavenImportWizard(ProjectImportConfiguration importConfiguration, List<String> locations, LifecycleMappingConfiguration mappingConfiguration) {
        this(importConfiguration, locations);
        this.mappingConfiguration = mappingConfiguration;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IPath location;
        super.init(workbench, selection);
        this.initialized = true;
        if ((this.locations == null || this.locations.isEmpty()) && (location = SelectionUtil.getSelectedLocation(selection)) != null) {
            this.locations = Collections.singletonList(location.toOSString());
        }
    }

    public void addPages() {
        if (!this.initialized) {
            this.init(null, null);
        }
        this.page = new MavenImportWizardPage(this.importConfiguration, this.workingSets);
        this.page.setLocations(this.locations);
        this.page.setShowLocation(this.showLocation);
        this.addPage((IWizardPage)this.page);
        if (this.getDiscovery() != null) {
            this.lifecycleMappingPage = new LifecycleMappingPage();
            this.addPage((IWizardPage)this.lifecycleMappingPage);
        }
    }

    public boolean performFinish() {
        if (!this.page.isPageComplete()) {
            return false;
        }
        if (this.lifecycleMappingPage != null && !this.lifecycleMappingPage.isMappingComplete() && !this.warnIncompleteMapping()) {
            return false;
        }
        final List<IMavenDiscoveryProposal> proposals = this.getMavenDiscoveryProposals();
        final Collection<MavenProjectInfo> projects = this.getProjects();
        final AbstractCreateMavenProjectsOperation importOperation = new AbstractCreateMavenProjectsOperation(this.workingSets){

            @Override
            protected List<IProject> doCreateMavenProjects(IProgressMonitor progressMonitor) throws CoreException {
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)101);
                try {
                    List results = MavenPlugin.getProjectConfigurationManager().importProjects(projects, MavenImportWizard.this.importConfiguration, (IProgressMonitor)monitor.newChild(proposals.isEmpty() ? 100 : 50));
                    ArrayList<IProject> arrayList = 1.toProjects(results);
                    return arrayList;
                }
                finally {
                    monitor.done();
                }
            }
        };
        boolean doImport = true;
        IMavenDiscoveryUI discovery = this.getPageFactory();
        if (discovery != null && !proposals.isEmpty()) {
            HashSet<String> projectsToConfigure = new HashSet<String>();
            for (MavenProjectInfo projectInfo : projects) {
                if (projectInfo.getModel() == null) continue;
                projectsToConfigure.add(this.importConfiguration.getProjectName(projectInfo.getModel()));
            }
            doImport = discovery.implement(proposals, importOperation, (IRunnableContext)this.getContainer(), projectsToConfigure);
        }
        if (doImport) {
            final IRunnableWithProgress ignoreJob = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ILifecycleMappingRequirement req;
                    LinkedList<IProject> changed = new LinkedList<IProject>();
                    for (ILifecycleMappingLabelProvider prov : MavenImportWizard.this.lifecycleMappingPage.getIgnore()) {
                        req = prov.getKey();
                        if (!(req instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)) continue;
                        changed.addAll(this.getProject(prov.getProjects()));
                        this.ignore(((MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)req).getExecution(), prov.getProjects());
                    }
                    for (ILifecycleMappingLabelProvider prov : MavenImportWizard.this.lifecycleMappingPage.getIgnoreParent()) {
                        req = prov.getKey();
                        if (!(req instanceof MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)) continue;
                        changed.addAll(this.getProject(prov.getProjects()));
                        this.ignoreAtDefinition(((MojoExecutionMappingConfiguration.MojoExecutionMappingRequirement)req).getExecution(), prov.getProjects());
                    }
                    new UpdateConfigurationJob(changed.toArray(new IProject[changed.size()])).schedule();
                }

                private Collection<IProject> getProject(Collection<MavenProject> projects) {
                    LinkedList<IProject> workspaceProjects = new LinkedList<IProject>();
                    for (MavenProject project : projects) {
                        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(project.getGroupId(), project.getArtifactId(), project.getVersion());
                        if (facade == null) continue;
                        workspaceProjects.add(facade.getProject());
                    }
                    return workspaceProjects;
                }

                private void ignore(MojoExecutionKey key, Collection<MavenProject> projects) {
                    String pluginGroupId = key.getGroupId();
                    String pluginArtifactId = key.getArtifactId();
                    String pluginVersion = key.getVersion();
                    String[] goals = new String[]{key.getGoal()};
                    for (MavenProject project : projects) {
                        IFile pomFile = M2EUtils.getPomFile((MavenProject)project);
                        try {
                            PomEdits.performOnDOMDocument(new PomEdits.OperationTuple(pomFile, (PomEdits.Operation)new LifecycleMappingOperation(pluginGroupId, pluginArtifactId, pluginVersion, PluginExecutionAction.ignore, goals)));
                        }
                        catch (IOException ex) {
                            LOG.error(ex.getMessage(), (Throwable)ex);
                        }
                        catch (CoreException ex) {
                            LOG.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }

                private void ignoreAtDefinition(MojoExecutionKey key, Collection<MavenProject> projects) {
                    this.ignore(key, M2EUtils.getDefiningProjects((MojoExecutionKey)key, projects));
                }
            };
            WorkspaceJob job = new WorkspaceJob(Messages.MavenImportWizard_job){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        importOperation.run(monitor);
                        if (MavenImportWizard.this.lifecycleMappingPage != null) {
                            ignoreJob.run(monitor);
                        }
                    }
                    catch (InvocationTargetException e) {
                        return AbstractCreateMavenProjectsOperation.toStatus(e);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
            job.schedule();
        }
        return doImport;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (!currentPage.isPageComplete()) {
            return false;
        }
        if (this.getDiscovery() == null) {
            return true;
        }
        if (currentPage == this.page) {
            return this.getMappingConfiguration().isMappingComplete(true) && this.getMappingConfiguration().getSelectedProposals().isEmpty();
        }
        return super.canFinish();
    }

    private List<IMavenDiscoveryProposal> getMavenDiscoveryProposals() {
        if (this.lifecycleMappingPage == null) {
            return Collections.emptyList();
        }
        return this.lifecycleMappingPage.getSelectedDiscoveryProposals();
    }

    public Collection<MavenProjectInfo> getProjects() {
        return this.page.getProjects();
    }

    public LifecycleMappingConfiguration getMappingConfiguration() {
        return this.mappingConfiguration;
    }

    void scanProjects(List<MavenProjectInfo> list, IProgressMonitor monitor) {
        LOG.debug("About to calculate lifecycle mapping configuration");
        ProjectImportConfiguration importConfiguration = this.getProjectImportConfiguration();
        this.mappingConfiguration = LifecycleMappingConfiguration.calculate(list, (ProjectImportConfiguration)importConfiguration, (IProgressMonitor)monitor);
        this.discoverProposals(this.mappingConfiguration, monitor);
    }

    void discoverProposals(LifecycleMappingConfiguration mappingConfiguration, IProgressMonitor monitor) {
        IMavenDiscovery discovery = this.getDiscovery();
        if (discovery == null) {
            return;
        }
        List projects = mappingConfiguration.getProjects();
        monitor.beginTask(Messages.MavenImportWizard_searchingTaskTitle, projects.size());
        LinkedHashMap proposals = new LinkedHashMap();
        for (ProjectLifecycleMappingConfiguration project : projects) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            MavenProject mavenProject = project.getMavenProject();
            List mojoExecutions = project.getMojoExecutions();
            try {
                proposals.putAll(discovery.discover(mavenProject, mojoExecutions, mappingConfiguration.getSelectedProposals(), (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.MavenImportWizard_analyzingProject, (Object)project.getRelpath()), (int)1)));
            }
            catch (CoreException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            monitor.worked(1);
        }
        mappingConfiguration.setProposals(proposals);
    }

    private boolean skipIncompleteWarning() {
        return M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("eclipse.m2.warn_incomplete_mapping");
    }

    private boolean warnIncompleteMapping() {
        if (!this.skipIncompleteWarning()) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.open((int)5, (Shell)this.getShell(), (String)Messages.MavenImportWizard_titleIncompleteMapping, (String)Messages.MavenImportWizard_messageIncompleteMapping, (String)Messages.MavenImportWizard_hideWarningMessage, (boolean)false, null, null, (int)0x10000000);
            if (dialog.getReturnCode() == 0) {
                M2EUIPluginActivator.getDefault().getPreferenceStore().setValue("eclipse.m2.warn_incomplete_mapping", dialog.getToggleState());
                return true;
            }
            return false;
        }
        return true;
    }
}

