/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.net4j.internal.util.bundle.OM;

public abstract class Timeouter {
    private Timer timer;
    private long timeout;
    private TimerTask timeoutTask;
    private long touched;

    public Timeouter(Timer timer, long timeout) {
        this.timer = timer;
        this.timeout = timeout;
        this.touched = System.currentTimeMillis();
        this.scheduleTimeout();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void touch() {
        this.touched = System.currentTimeMillis();
    }

    public void dispose() {
        if (this.timeoutTask != null) {
            TimerTask task = this.timeoutTask;
            this.timeoutTask = null;
            task.cancel();
        }
    }

    protected boolean isDisposed() {
        return this.timeoutTask == null;
    }

    protected abstract void handleTimeout(long var1);

    private void scheduleTimeout() {
        this.timeoutTask = new TimerTask(){

            public void run() {
                try {
                    if (!Timeouter.this.isDisposed()) {
                        long untouched = System.currentTimeMillis() - Timeouter.this.touched;
                        if (untouched > Timeouter.this.timeout) {
                            Timeouter.this.timeoutTask = null;
                            Timeouter.this.handleTimeout(untouched);
                        } else {
                            Timeouter.this.scheduleTimeout();
                        }
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error("TimeouterTask failed", ex);
                }
            }
        };
        try {
            long delay = Math.max(this.timeout - (System.currentTimeMillis() - this.touched), 0L);
            this.timer.schedule(this.timeoutTask, delay);
        }
        catch (Exception ex) {
            OM.LOG.error(ex);
        }
    }
}

