/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.launcher.ui.tabs;

import com.fusesource.rider.launcher.ui.Activator;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class CamelContextFileTab
extends AbstractLaunchConfigurationTab {
    private FilteredResourcesSelectionDialog browseDialog;
    private Text camelContextFileText;

    public void createControl(Composite parent) {
        Composite c = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)1808);
        this.setControl((Control)c);
        Group group = SWTFactory.createGroup((Composite)c, (String)"Select Camel Context file...", (int)2, (int)1, (int)768);
        this.camelContextFileText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.camelContextFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CamelContextFileTab.this.setDirty(true);
                CamelContextFileTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button selectFileButton = SWTFactory.createPushButton((Composite)group, (String)"Browse...", null);
        selectFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
                CamelContextFileTab.this.browseDialog = new FilteredResourcesSelectionDialog(e.display.getActiveShell(), false, (IContainer)container, 1){

                    protected void fillContentProvider(final FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
                        FilteredItemsSelectionDialog.AbstractContentProvider filteringContentProvider = new FilteredItemsSelectionDialog.AbstractContentProvider((FilteredItemsSelectionDialog)this){

                            public synchronized void add(Object item, FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
                                block14: {
                                    if (itemsFilter.matchItem(item) && item instanceof IFile) {
                                        IFile ifile = (IFile)item;
                                        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                                        InputStream stream = null;
                                        try {
                                            try {
                                                stream = ifile.getContents(true);
                                                IContentType t = contentTypeManager.findContentTypeFor(stream, ifile.getName());
                                                if (t.getId().equals("com.fusesource.rider.editor.camelContentType")) {
                                                    contentProvider.add(item, itemsFilter);
                                                }
                                            }
                                            catch (Exception ex) {
                                                Activator.error(ex);
                                                if (stream == null) break block14;
                                                try {
                                                    stream.close();
                                                }
                                                catch (IOException ex2) {
                                                    Activator.error(ex2);
                                                }
                                            }
                                        }
                                        finally {
                                            if (stream != null) {
                                                try {
                                                    stream.close();
                                                }
                                                catch (IOException ex) {
                                                    Activator.error(ex);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        };
                        super.fillContentProvider(filteringContentProvider, itemsFilter, progressMonitor);
                    }
                };
                CamelContextFileTab.this.browseDialog.setInitialPattern("*.xml", 2);
                CamelContextFileTab.this.browseDialog.setBlockOnOpen(true);
                CamelContextFileTab.this.browseDialog.open();
                if (CamelContextFileTab.this.browseDialog.getReturnCode() == 0) {
                    Object[] res = CamelContextFileTab.this.browseDialog.getResult();
                    IFile f = (IFile)res[0];
                    CamelContextFileTab.this.camelContextFileText.setText(f.getLocation().toOSString());
                }
                CamelContextFileTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Dialog.applyDialogFont((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("rider.file", "camelContext.xml");
        configuration.setAttribute("M2_GOALS", "clean package org.apache.camel:camel-maven-plugin:run");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.camelContextFileText.setText(configuration.getAttribute("rider.file", "camelContext.xml"));
        }
        catch (CoreException coreException) {
            this.camelContextFileText.setText("camelContext.xml");
        }
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("rider.file", this.camelContextFileText.getText().trim());
        this.setDirty(false);
    }

    public String getName() {
        return "Camel Context File";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        Path file = new Path(this.camelContextFileText.getText());
        if (file.toFile().exists() && file.toFile().isFile()) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage("Please select the Camel context file you want to start.");
        return false;
    }

    public boolean canSave() {
        return this.isValid(null);
    }
}

