/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper;

import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.model.IDataModelSource;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModelSource;
import com.fusesource.zk.zookeeper.runtime.ZooKeeperConnectionDescriptorFiles;
import java.io.File;
import org.apache.zookeeper.KeeperException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class ZooKeeperActivator
extends AbstractUIPlugin {
    public static final String ZOO_KEEPER_VERSION = String.valueOf(String.valueOf(3)) + "." + String.valueOf(4) + "." + String.valueOf(3);
    public static final String VERSION_SUFFIX = "";
    public static final String PLUGIN_ID = "com.fusesource.zk.zookeeper";
    public static final String IMAGE_KEY_ACTION_NEW_ZNODE = "IMAGE_KEY_ACTION_NEW_ZNODE";
    public static final String IMAGE_KEY_ACTION_NEW_ZOO_KEEPER_CONNECTION = "IMAGE_KEY_ACTION_NEW_ZOO_KEEPER_CONNECTION";
    public static final String IMAGE_KEY_ACTION_TABLE_EDIT_CHILDREN = "IMAGE_KEY_ACTION_TABLE_EDIT_CHILDREN";
    public static final String IMAGE_KEY_DIALOG_ADD_AUTH_INFO = "IMAGE_KEY_DIALOG_ADD_AUTH_INFO";
    public static final String IMAGE_KEY_OBJECT_AUTH = "IMAGE_KEY_OBJECT_AUTH";
    public static final String IMAGE_KEY_OBJECT_ZNODE = "IMAGE_KEY_OBJECT_ZNODE";
    public static final String IMAGE_KEY_OBJECT_ZNODE_ACL = "IMAGE_KEY_OBJECT_ZNODE_ACL";
    public static final String IMAGE_KEY_OBJECT_ZNODE_CHILDREN = "IMAGE_KEY_OBJECT_ZNODE_CHILDREN";
    public static final String IMAGE_KEY_OBJECT_ZNODE_DATA = "IMAGE_KEY_OBJECT_ZNODE_DATA";
    public static final String IMAGE_KEY_OBJECT_ZNODE_EPHEMERAL = "IMAGE_KEY_OBJECT_ZNODE_EPHEMERAL";
    public static final String IMAGE_KEY_OBJECT_ZNODE_EPHEMERAL_LARGE = "IMAGE_KEY_OBJECT_ZNODE_EPHEMERAL_LARGE";
    public static final String IMAGE_KEY_OBJECT_ZNODE_LARGE = "IMAGE_KEY_OBJECT_ZNODE_LARGE";
    public static final String IMAGE_KEY_OBJECT_ZNODE_LEAF = "IMAGE_KEY_OBJECT_ZNODE_LEAF";
    public static final String IMAGE_KEY_OBJECT_ZNODE_LEAF_LARGE = "IMAGE_KEY_OBJECT_ZNODE_LEAF_LARGE";
    public static final String IMAGE_KEY_OBJECT_ZNODE_STAT = "IMAGE_KEY_OBJECT_ZNODE_STAT";
    public static final String IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION = "IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION";
    public static final String IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_LARGE = "IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_LARGE";
    public static final String IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED = "IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED";
    public static final String IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED_LARGE = "IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED_LARGE";
    public static final String IMAGE_KEY_WIZARD_BANNER_NEW_ZNODE = "IMAGE_KEY_WIZARD_BANNER_NEW_ZNODE";
    public static final String IMAGE_KEY_WIZARD_BANNER_NEW_ZOO_KEEPER_CONNECTION = "IMAGE_KEY_WIZARD_BANNER_NEW_ZOO_KEEPER_CONNECTION";
    public static final String IMAGE_KEY_WIZARD_NEW_ZNODE = "IMAGE_KEY_WIZARD_NEW_ZNODE";
    public static final String IMAGE_KEY_WIZARD_NEW_ZOO_KEEPER_CONNECTION = "IMAGE_KEY_WIZARD_NEW_ZOO_KEEPER_CONNECTION";
    private static final String IMAGE_PATH_ACTION = "resources/images/png/actions/";
    private static final String IMAGE_PATH_ACTION_NEW_ZNODE = "resources/images/png/actions/new-znode.png";
    private static final String IMAGE_PATH_ACTION_NEW_ZOO_KEEPER_CONNECTION = "resources/images/png/actions/new-zookeeper-connection.png";
    private static final String IMAGE_PATH_ACTION_TABLE_EDIT_CHILDREN = "resources/images/png/actions/table-edit-children.png";
    private static final String IMAGE_PATH_DIALOG = "resources/images/png/dialogs/";
    private static final String IMAGE_PATH_DIALOG_ADD_AUTH_INFO = "resources/images/png/dialogs/add-auth-info.png";
    private static final String IMAGE_PATH_OBJECT = "resources/images/png/objects/";
    private static final String IMAGE_PATH_OBJECT_AUTH = "resources/images/png/objects/auth.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE = "resources/images/png/objects/znode.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_ACL = "resources/images/png/objects/znode-acl.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_CHILDREN = "resources/images/png/objects/znode-children.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_DATA = "resources/images/png/objects/znode-data.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_EPHEMERAL = "resources/images/png/objects/znode-ephemeral.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_EPHEMERAL_LARGE = "resources/images/png/objects/znode-ephemeral_large.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_LARGE = "resources/images/png/objects/znode_large.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_LEAF = "resources/images/png/objects/znode-leaf.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_LEAF_LARGE = "resources/images/png/objects/znode-leaf_large.png";
    private static final String IMAGE_PATH_OBJECT_ZNODE_STAT = "resources/images/png/objects/znode-stat.png";
    private static final String IMAGE_PATH_OBJECT_ZOO_KEEPER_CONNECTION = "resources/images/png/objects/zookeeper-connection.png";
    private static final String IMAGE_PATH_OBJECT_ZOO_KEEPER_CONNECTION_LARGE = "resources/images/png/objects/zookeeper-connection_large.png";
    private static final String IMAGE_PATH_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED = "resources/images/png/objects/zookeeper-connection_not_connected.png";
    private static final String IMAGE_PATH_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED_LARGE = "resources/images/png/objects/zookeeper-connection_not_connected_large.png";
    private static final String IMAGE_PATH_WIZARD = "resources/images/png/wizards/";
    private static final String IMAGE_PATH_WIZARD_NEW_ZNODE = "resources/images/png/wizards/new-znode.png";
    private static final String IMAGE_PATH_WIZARD_NEW_ZOO_KEEPER_CONNECTION = "resources/images/png/wizards/new-zookeeper-connection.png";
    private static final String IMAGE_PATH_WIZARD_BANNER = "resources/images/png/wizard-banners/";
    private static final String IMAGE_PATH_WIZARD_BANNER_NEW_ZNODE = "resources/images/png/wizard-banners/new-znode.png";
    private static final String IMAGE_PATH_WIZARD_BANNER_NEW_ZOO_KEEPER_CONNECTION = "resources/images/png/wizard-banners/new-zookeeper-connection.png";
    private static ZooKeeperActivator __Plugin;
    private ZooKeeperConnectionDescriptorFiles _ZooKeeperConnectionDescriptorFiles;
    private DataModelManager<ZooKeeperConnectionModel, ZooKeeperConnectionDescriptor, ZooKeeperConnection> _ZooKeeperConnectionModelManager;

    public static ImageDescriptor getImageDescriptor(String path) {
        return ZooKeeperActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getManagedImage(String key) {
        return __Plugin.getImageRegistry().get(key);
    }

    public static ImageDescriptor getManagedImageDescriptor(String key) {
        return __Plugin.getImageRegistry().getDescriptor(key);
    }

    public static ZooKeeperActivator getDefault() {
        return __Plugin;
    }

    public static Image getZnodeLargeImage(Znode znode) {
        return ZooKeeperActivator.getManagedImage(ZooKeeperActivator.getZnodeLargeImageKey(znode));
    }

    public static ImageDescriptor getZnodeLargeImageDescriptor(Znode znode) {
        return ZooKeeperActivator.getManagedImageDescriptor(ZooKeeperActivator.getZnodeLargeImageKey(znode));
    }

    public static Image getZnodeSmallImage(Znode znode) {
        return ZooKeeperActivator.getManagedImage(ZooKeeperActivator.getZnodeSmallImageKey(znode));
    }

    public static ImageDescriptor getZnodeSmallImageDescriptor(Znode znode) {
        return ZooKeeperActivator.getManagedImageDescriptor(ZooKeeperActivator.getZnodeSmallImageKey(znode));
    }

    public static void reportError(Throwable t) {
        Throwable cause = t.getCause();
        if (cause != null && cause != t) {
            ZooKeeperActivator.reportError(cause);
            return;
        }
        boolean showCustomErrorMessageDialog = false;
        int style = 1;
        String title = "Error";
        String message = t.getLocalizedMessage();
        if (t instanceof KeeperException) {
            KeeperException ke = (KeeperException)t;
            title = "ZooKeeper Error";
            showCustomErrorMessageDialog = true;
            if (ke instanceof KeeperException.InvalidACLException) {
                title = "Invalid ACL";
                message = "ACL is invalid for '" + ke.getPath() + "'.";
            } else if (ke instanceof KeeperException.NodeExistsException) {
                title = "Znode Exists";
                message = "Znode '" + ke.getPath() + "' already exists.";
            } else if (ke instanceof KeeperException.NoAuthException) {
                title = "Not Authorized";
                message = "Not authorized to perform this action on '" + ke.getPath() + "'.";
            } else if (ke instanceof KeeperException.NoNodeException) {
                title = "No Znode";
                message = "Znode '" + ke.getPath() + "' does not exist.";
            } else if (ke instanceof KeeperException.NotEmptyException) {
                title = "Not Empty";
                message = "Znode '" + ke.getPath() + "' has children.";
            }
        }
        if (showCustomErrorMessageDialog) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else {
            style |= 4;
        }
        Status status = new Status(4, PLUGIN_ID, message, t);
        StatusManager.getManager().handle((IStatus)status, style);
    }

    private static String getZnodeLargeImageKey(Znode znode) {
        return String.valueOf(ZooKeeperActivator.getZnodeSmallImageKey(znode)) + "_LARGE";
    }

    private static String getZnodeSmallImageKey(Znode znode) {
        String imageKey = null;
        imageKey = znode.isLeaf() ? (znode.isEphemeral() ? IMAGE_KEY_OBJECT_ZNODE_EPHEMERAL : IMAGE_KEY_OBJECT_ZNODE_LEAF) : IMAGE_KEY_OBJECT_ZNODE;
        return imageKey;
    }

    public File getZnodeDataDirectory() {
        return this.getStateLocation().append("Znode").append("Data").toFile();
    }

    public ZooKeeperConnectionDescriptorFiles getZooKeeperConnectionDescriptorFiles() {
        return this._ZooKeeperConnectionDescriptorFiles;
    }

    public DataModelManager<ZooKeeperConnectionModel, ZooKeeperConnectionDescriptor, ZooKeeperConnection> getZooKeeperConnectionModelManager() {
        return this._ZooKeeperConnectionModelManager;
    }

    public File getZooKeeperConnectionsDirectory() {
        return this.getStateLocation().append("ZooKeeperConnections").toFile();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __Plugin = this;
        this._ZooKeeperConnectionDescriptorFiles = new ZooKeeperConnectionDescriptorFiles(this.getZooKeeperConnectionsDirectory());
        ZooKeeperConnectionModelSource zooKeeperConnectionModelSource = new ZooKeeperConnectionModelSource(this._ZooKeeperConnectionDescriptorFiles);
        this._ZooKeeperConnectionModelManager = new DataModelManager((IDataModelSource)zooKeeperConnectionModelSource);
    }

    public void stop(BundleContext context) throws Exception {
        __Plugin = null;
        this._ZooKeeperConnectionModelManager.destroy();
        this._ZooKeeperConnectionModelManager = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        super.initializeImageRegistry(imageRegistry);
        imageRegistry.put(IMAGE_KEY_ACTION_NEW_ZNODE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_ACTION_NEW_ZNODE));
        imageRegistry.put(IMAGE_KEY_ACTION_NEW_ZOO_KEEPER_CONNECTION, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_ACTION_NEW_ZOO_KEEPER_CONNECTION));
        imageRegistry.put(IMAGE_KEY_ACTION_TABLE_EDIT_CHILDREN, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_ACTION_TABLE_EDIT_CHILDREN));
        imageRegistry.put(IMAGE_KEY_DIALOG_ADD_AUTH_INFO, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_DIALOG_ADD_AUTH_INFO));
        imageRegistry.put(IMAGE_KEY_OBJECT_AUTH, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_AUTH));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_LARGE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_LARGE));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_LEAF, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_LEAF));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_LEAF_LARGE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_LEAF_LARGE));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_EPHEMERAL, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_EPHEMERAL));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_EPHEMERAL_LARGE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_EPHEMERAL_LARGE));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_ACL, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_ACL));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_CHILDREN, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_CHILDREN));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_DATA, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_DATA));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZNODE_STAT, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZNODE_STAT));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZOO_KEEPER_CONNECTION));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_LARGE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZOO_KEEPER_CONNECTION_LARGE));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED));
        imageRegistry.put(IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED_LARGE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED_LARGE));
        imageRegistry.put(IMAGE_KEY_WIZARD_NEW_ZOO_KEEPER_CONNECTION, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_WIZARD_NEW_ZOO_KEEPER_CONNECTION));
        imageRegistry.put(IMAGE_KEY_WIZARD_NEW_ZNODE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_WIZARD_NEW_ZNODE));
        imageRegistry.put(IMAGE_KEY_WIZARD_BANNER_NEW_ZOO_KEEPER_CONNECTION, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_WIZARD_BANNER_NEW_ZOO_KEEPER_CONNECTION));
        imageRegistry.put(IMAGE_KEY_WIZARD_BANNER_NEW_ZNODE, ZooKeeperActivator.getImageDescriptor(IMAGE_PATH_WIZARD_BANNER_NEW_ZNODE));
    }
}

