/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.actions;

import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.actions.BaseWizardAction;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelEditorInput;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.wizards.newznode.ZnodeNewWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWizard;

public class NewZnodeAction
extends BaseWizardAction {
    private static final ImageDescriptor ACTION_IMAGE_DESCRIPTOR = ZooKeeperActivator.getManagedImageDescriptor("IMAGE_KEY_ACTION_NEW_ZNODE");
    private static final String ACTION_TEXT = "New Znode...";
    private static final String ACTION_TOOL_TIP_TEXT = "New Znode...";

    public NewZnodeAction(BaseAction.InputType inputType) {
        super(inputType);
        this.setText("New Znode...");
        this.setToolTipText("New Znode...");
        this.setImageDescriptor(ACTION_IMAGE_DESCRIPTOR);
        this.addInputTypeClass(ZnodeModel.class);
        this.addInputTypeClass(ZnodeModelEditorInput.class);
    }

    public boolean canRunWithObject(Object object) {
        ZnodeModel znodeModel = null;
        if (object instanceof ZnodeModel) {
            znodeModel = (ZnodeModel)((Object)object);
        } else if (object instanceof ZnodeModelEditorInput) {
            znodeModel = (ZnodeModel)((ZnodeModelEditorInput)((Object)object)).getModel();
        }
        if (znodeModel == null) {
            return false;
        }
        Znode znode = (Znode)znodeModel.getData();
        return !znode.isEphemeral() && !Znode.isSystemPath(znode.getPath());
    }

    protected IWorkbenchWizard getWizard(IStructuredSelection selection) {
        return new ZnodeNewWizard();
    }
}

