/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.actions;

import com.fusesource.zk.core.actions.BaseDeleteAction;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;

public class ZooKeeperDeleteAction
extends BaseDeleteAction {
    public ZooKeeperDeleteAction() {
        this.addInputTypeClass(ZooKeeperConnectionModel.class);
        this.addInputTypeClass(ZnodeModel.class);
    }

    public boolean canRunWithObject(Object object) {
        if (object instanceof ZnodeModel) {
            ZnodeModel znodeModel = (ZnodeModel)((Object)object);
            Znode znode = (Znode)znodeModel.getData();
            return znode.isLeaf() && !Znode.isSystemPath(znode.getPath());
        }
        return true;
    }

    public void reportError(Exception e) {
        ZooKeeperActivator.reportError(e);
    }

    protected String getObjectName(Object selectedObject) {
        if (selectedObject instanceof ZooKeeperConnectionModel) {
            return ((ZooKeeperConnection)((ZooKeeperConnectionModel)((Object)selectedObject)).getData()).getDescriptor().getName();
        }
        if (selectedObject instanceof ZnodeModel) {
            return ((Znode)((ZnodeModel)((Object)selectedObject)).getData()).getPath();
        }
        return null;
    }

    protected String getObjectTypeName(Object selectedObject) {
        if (selectedObject instanceof ZooKeeperConnectionModel) {
            return "ZooKeeper connection";
        }
        if (selectedObject instanceof ZnodeModel) {
            return "Znode";
        }
        return null;
    }
}

