/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.data;

import com.fusesource.zk.core.ui.FileEditor;
import java.io.File;
import java.io.IOException;

public final class AuthInfo
implements Comparable<AuthInfo> {
    private final String _AuthString;
    private final String _Scheme;
    private final Type _Type;

    public AuthInfo(Type type, String scheme, String authString) {
        this._Type = type;
        this._Scheme = scheme;
        this._AuthString = authString;
    }

    @Override
    public int compareTo(AuthInfo o) {
        int result = this.getType().name().compareTo(o.getType().name());
        if (result == 0) {
            result = this.getScheme().compareTo(o.getScheme());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthInfo other = (AuthInfo)obj;
        if (this._AuthString == null ? other._AuthString != null : !this._AuthString.equals(other._AuthString)) {
            return false;
        }
        if (this._Scheme == null ? other._Scheme != null : !this._Scheme.equals(other._Scheme)) {
            return false;
        }
        return !(this._Type == null ? other._Type != null : !this._Type.equals((Object)other._Type));
    }

    public byte[] getAuth() throws IOException {
        Type type = this.getType();
        String authString = this.getAuthString();
        if (type.equals((Object)Type.Text)) {
            return authString.getBytes();
        }
        if (type.equals((Object)Type.File)) {
            return FileEditor.readFile((File)new File(authString));
        }
        return null;
    }

    public String getAuthString() {
        return this._AuthString;
    }

    public String getScheme() {
        return this._Scheme;
    }

    public Type getType() {
        return this._Type;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._AuthString == null ? 0 : this._AuthString.hashCode());
        result = 31 * result + (this._Scheme == null ? 0 : this._Scheme.hashCode());
        result = 31 * result + (this._Type == null ? 0 : this._Type.hashCode());
        return result;
    }

    public String toString() {
        return "AuthInfo [" + (this._Type != null ? "Type=" + (Object)((Object)this._Type) + ", " : "") + (this._Scheme != null ? "Scheme=" + this._Scheme + ", " : "") + (this._AuthString != null ? "AuthString=" + this._AuthString : "") + "]";
    }

    public static enum Type {
        File,
        Text;

    }
}

