/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.data;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public final class Znode {
    public static final long MAX_DATA_SIZE = 0x100000L;
    public static final char PATH_SEPARATOR_CHAR = '/';
    public static final String PATH_SEPARATOR_STRING;
    public static final String ROOT_PATH;
    public static final String STAT_DESCRIPTION_AVERSION = "The number of changes to the ACL of this znode.";
    public static final String STAT_DESCRIPTION_CTIME = "The time when this znode was created.";
    public static final String STAT_DESCRIPTION_CVERSION = "The number of changes to the children of this znode.";
    public static final String STAT_DESCRIPTION_CZXID = "The zxid of the change that caused this znode to be created.";
    public static final String STAT_DESCRIPTION_DATA_LENGTH = "The length of the data field of this znode.";
    public static final String STAT_DESCRIPTION_EPHEMERAL_OWNER = "The session id of the owner of this znode if the znode is an ephemeral node.";
    public static final String STAT_DESCRIPTION_MTIME = "The time when this znode was last modified.";
    public static final String STAT_DESCRIPTION_MZXID = "The zxid of the change that last modified this znode.";
    public static final String STAT_DESCRIPTION_NUM_CHILDREN = "The number of children of this znode.";
    public static final String STAT_DESCRIPTION_VERSION = "The number of changes to the data of this znode.";
    public static final String STAT_NAME_AVERSION = "aversion";
    public static final String STAT_NAME_CTIME = "ctime";
    public static final String STAT_NAME_CVERSION = "cversion";
    public static final String STAT_NAME_CZXID = "czxid";
    public static final String STAT_NAME_DATA_LENGTH = "dataLength";
    public static final String STAT_NAME_EPHEMERAL_OWNER = "ephemeralOwner";
    public static final String STAT_NAME_MTIME = "mtime";
    public static final String STAT_NAME_MZXID = "mzxid";
    public static final String STAT_NAME_NUM_CHILDREN = "numChildren";
    public static final String STAT_NAME_VERSION = "version";
    public static final String ZNODE_PATH_ZOOKEEPER;
    public static final String ZNODE_PATH_ZOOKEEPER_QUOTA;
    private static final Charset CHARSET;
    private List<ACL> _Acl;
    private boolean _AclReadable;
    private List<String> _Children;
    private boolean _ChildrenReadable;
    private byte[] _Data;
    private boolean _DataReadable;
    private String _DataString;
    private boolean _Ephemeral;
    private final String _ParentPath;
    private final String _Path;
    private final String _RelativePath;
    private boolean _Sequential;
    private Stat _Stat;

    static {
        ROOT_PATH = PATH_SEPARATOR_STRING = String.valueOf('/');
        ZNODE_PATH_ZOOKEEPER = String.valueOf(ROOT_PATH) + "zookeeper";
        ZNODE_PATH_ZOOKEEPER_QUOTA = String.valueOf(ZNODE_PATH_ZOOKEEPER) + PATH_SEPARATOR_STRING + "quota";
        CHARSET = Charset.forName("UTF-8");
    }

    public static final void validatePath(String absolutePath, boolean isSequential) throws IllegalArgumentException {
        PathUtils.validatePath((String)absolutePath, (boolean)isSequential);
    }

    public static final String getAbsolutePath(String parentPath, String relativePath) {
        String absolutePath = parentPath.equals(ROOT_PATH) ? String.valueOf(ROOT_PATH) + relativePath : String.valueOf(parentPath) + PATH_SEPARATOR_STRING + relativePath;
        return absolutePath;
    }

    public static final String getParentPath(String absolutePath) {
        return Znode.splitPath(absolutePath)[0];
    }

    public static final String getRelativePath(String absolutePath) {
        return Znode.splitPath(absolutePath)[1];
    }

    public static boolean isSystemPath(String absolutePath) {
        return absolutePath.startsWith(ZNODE_PATH_ZOOKEEPER);
    }

    public static final String[] splitPath(String absolutePath) {
        String[] splitPath = new String[2];
        if (absolutePath.equals(ROOT_PATH)) {
            splitPath[0] = null;
            splitPath[1] = absolutePath;
        } else {
            int lastSeparatorIndex = absolutePath.lastIndexOf(47);
            splitPath[0] = lastSeparatorIndex == 0 ? ROOT_PATH : absolutePath.substring(0, lastSeparatorIndex);
            splitPath[1] = absolutePath.substring(lastSeparatorIndex + 1);
        }
        return splitPath;
    }

    public Znode(String path) {
        this._Path = path;
        String[] splitPath = Znode.splitPath(path);
        this._ParentPath = splitPath[0];
        this._RelativePath = splitPath[1];
    }

    public List<ACL> getAcl() {
        return this._Acl;
    }

    public List<String> getChildren() {
        return this._Children;
    }

    public byte[] getData() {
        return this._Data;
    }

    public String getDataAsString() {
        if (this._DataString == null) {
            this._DataString = this._Data != null ? new String(this._Data, CHARSET) : "";
        }
        return this._DataString;
    }

    public String getParentPath() {
        return this._ParentPath;
    }

    public String getPath() {
        return this._Path;
    }

    public String getRelativePath() {
        return this._RelativePath;
    }

    public Stat getStat() {
        return this._Stat;
    }

    public boolean isAclReadable() {
        return this._AclReadable;
    }

    public boolean isChildrenReadable() {
        return this._ChildrenReadable;
    }

    public boolean isDataReadable() {
        return this._DataReadable;
    }

    public boolean isEphemeral() {
        return this._Ephemeral;
    }

    public boolean isLeaf() {
        List<String> children = this.getChildren();
        return children == null || this.getChildren().size() == 0;
    }

    public boolean isSequential() {
        return this._Sequential;
    }

    public void setAcl(List<ACL> acl) {
        this._Acl = acl;
    }

    public void setAclReadable(boolean aclReadable) {
        this._AclReadable = aclReadable;
    }

    public void setChildren(List<String> children) {
        this._Children = children;
    }

    public void setChildrenReadable(boolean childrenReadable) {
        this._ChildrenReadable = childrenReadable;
    }

    public void setData(byte[] data) {
        this._Data = data;
        this._DataString = null;
    }

    public void setDataReadable(boolean dataReadable) {
        this._DataReadable = dataReadable;
    }

    public void setEphemeral(boolean ephemeral) {
        this._Ephemeral = ephemeral;
    }

    public void setSequential(boolean sequential) {
        this._Sequential = sequential;
    }

    public void setStat(Stat stat) {
        this._Stat = stat;
        this.setEphemeral(stat.getEphemeralOwner() > 0L);
    }

    public String toString() {
        return "Znode [" + (this._Path != null ? "Path=" + this._Path + ", " : "") + (this._DataString != null ? "DataString=" + this._DataString : "") + "]";
    }
}

