/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.data;

import com.fusesource.zk.zookeeper.data.AuthInfo;
import com.fusesource.zk.zookeeper.data.IZooKeeperConnectionEventListener;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionEvent;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public final class ZooKeeperConnection
implements Watcher {
    private final ZooKeeperConnectionDescriptor _Descriptor;
    private CopyOnWriteArrayList<IZooKeeperConnectionEventListener> _EventListeners;
    private ZooKeeper _ZooKeeper;

    public ZooKeeperConnection(ZooKeeperConnectionDescriptor descriptor) {
        this._Descriptor = descriptor;
    }

    public void addEventListener(IZooKeeperConnectionEventListener listener) {
        if (this._EventListeners == null) {
            this._EventListeners = new CopyOnWriteArrayList();
        }
        if (!this._EventListeners.contains(listener)) {
            this._EventListeners.add(listener);
        }
    }

    public void close() throws InterruptedException {
        if (this._ZooKeeper == null) {
            return;
        }
        this._ZooKeeper.close();
        this._ZooKeeper = null;
        this.fireConnectionStateChanged();
    }

    public void connect() throws IOException {
        if (this._ZooKeeper != null && this._ZooKeeper.getState().isAlive()) {
            return;
        }
        String connectString = this._Descriptor.getConnectString();
        this._ZooKeeper = new ZooKeeper(connectString, this._Descriptor.getSessionTimeout(), (Watcher)this);
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        return this._ZooKeeper.create(path, data, acl, createMode);
    }

    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this._ZooKeeper.delete(path, version);
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._ZooKeeper.exists(path, watch);
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this._ZooKeeper.exists(path, watcher);
    }

    public List<ACL> getACL(String path, Stat stat) throws KeeperException, InterruptedException {
        return this._ZooKeeper.getACL(path, stat);
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this._ZooKeeper.getChildren(path, watch);
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this._ZooKeeper.getChildren(path, watcher);
    }

    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this._ZooKeeper.getData(path, watch, stat);
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this._ZooKeeper.getData(path, watcher, stat);
    }

    public ZooKeeperConnectionDescriptor getDescriptor() {
        return this._Descriptor;
    }

    public long getSessionId() {
        if (this._ZooKeeper == null) {
            return 0L;
        }
        return this._ZooKeeper.getSessionId();
    }

    public byte[] getSessionPasswd() {
        if (this._ZooKeeper == null) {
            return null;
        }
        return this._ZooKeeper.getSessionPasswd();
    }

    public ZooKeeper.States getState() {
        if (this._ZooKeeper == null) {
            return ZooKeeper.States.CLOSED;
        }
        return this._ZooKeeper.getState();
    }

    public Znode getZnode(String path) throws KeeperException, InterruptedException {
        if (!this.isConnected()) {
            return null;
        }
        Znode znode = null;
        Stat stat = this.exists(path, false);
        if (stat == null) {
            return null;
        }
        znode = new Znode(path);
        znode.setStat(stat);
        byte[] data = null;
        try {
            data = this.getData(path, false, stat);
            znode.setData(data);
            znode.setDataReadable(true);
        }
        catch (Exception exception) {}
        List<ACL> acl = null;
        try {
            acl = this.getACL(path, stat);
            znode.setAcl(acl);
            znode.setAclReadable(true);
        }
        catch (Exception exception) {}
        List<String> children = null;
        try {
            children = this.getChildren(path, false);
            znode.setChildren(children);
            znode.setChildrenReadable(true);
        }
        catch (Exception exception) {}
        return znode;
    }

    public boolean isConnected() {
        return this.getState() == ZooKeeper.States.CONNECTED;
    }

    public void process(WatchedEvent event) {
        ZooKeeperConnectionDescriptor zooKeeperConnectionDescriptor;
        List<AuthInfo> authInfos;
        Watcher.Event.KeeperState state = event.getState();
        if (state == Watcher.Event.KeeperState.SyncConnected && (authInfos = (zooKeeperConnectionDescriptor = this.getDescriptor()).getAuthInfos()) != null && !authInfos.isEmpty()) {
            for (AuthInfo authInfo : authInfos) {
                byte[] auth;
                String scheme = authInfo.getScheme();
                try {
                    auth = authInfo.getAuth();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                this.addAuthInfo(scheme, auth);
            }
        }
        this.fireConnectionStateChanged();
    }

    public void removeEventListener(IZooKeeperConnectionEventListener listener) {
        if (this._EventListeners == null) {
            return;
        }
        if (!this._EventListeners.contains(listener)) {
            return;
        }
        this._EventListeners.remove(listener);
    }

    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        return this._ZooKeeper.setACL(path, acl, version);
    }

    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this._ZooKeeper.setData(path, data, version);
    }

    public String toString() {
        return "ZooKeeperConnection [Descriptor=" + (Object)((Object)this._Descriptor) + "]";
    }

    private void addAuthInfo(String scheme, byte[] auth) {
        this._ZooKeeper.addAuthInfo(scheme, auth);
    }

    private void fireConnectionStateChanged() {
        if (this._EventListeners != null) {
            ZooKeeperConnectionEvent event = new ZooKeeperConnectionEvent(this);
            for (IZooKeeperConnectionEventListener listener : this._EventListeners) {
                listener.connectionStateChanged(event);
            }
        }
    }
}

