/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.data;

import com.fusesource.zk.core.data.AbstractConnectionDescriptor;
import com.fusesource.zk.zookeeper.data.AuthInfo;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class ZooKeeperConnectionDescriptor
extends AbstractConnectionDescriptor<ZooKeeperConnectionDescriptor> {
    public static final String DEFAULT_NAME = "My ZooKeeper";
    public static final int DEFAULT_SESSION_TIMEOUT = 5000;
    public static final int NAME_LENGTH_LIMIT = 100;
    private List<AuthInfo> _AuthInfos;
    private String _RootPath;
    private final Set<ZooKeeperServerDescriptor> _Servers;
    private int _SessionTimeout;

    public static String buildConnectString(Set<ZooKeeperServerDescriptor> servers, String rootPath) {
        if (servers.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (ZooKeeperServerDescriptor server : servers) {
            builder.append(server.getHostPortString()).append(',');
        }
        String connectString = builder.substring(0, builder.length() - 1);
        if (rootPath != null && !rootPath.equals(Znode.ROOT_PATH)) {
            if (!rootPath.startsWith(Znode.ROOT_PATH)) {
                rootPath = String.valueOf(Znode.ROOT_PATH) + rootPath;
            }
            connectString = String.valueOf(connectString) + rootPath;
        }
        return connectString;
    }

    public ZooKeeperConnectionDescriptor(String name, int sessionTimeout) {
        super(name);
        this._SessionTimeout = sessionTimeout;
        this._Servers = new TreeSet<ZooKeeperServerDescriptor>();
    }

    public List<AuthInfo> getAuthInfos() {
        if (this._AuthInfos == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._AuthInfos);
    }

    public String getConnectString() {
        return ZooKeeperConnectionDescriptor.buildConnectString(this._Servers, this.getRootPath());
    }

    public String getRootPath() {
        return this._RootPath;
    }

    public Set<ZooKeeperServerDescriptor> getServers() {
        return this._Servers;
    }

    public int getSessionTimeout() {
        return this._SessionTimeout;
    }

    public void setAuthInfos(List<AuthInfo> authInfos) {
        this._AuthInfos = authInfos;
    }

    public void setRootPath(String rootPath) {
        this._RootPath = rootPath;
    }

    public final void setServers(Collection<ZooKeeperServerDescriptor> servers) {
        this._Servers.clear();
        this._Servers.addAll(servers);
    }

    public final void setSessionTimeout(int sessionTimeout) {
        this._SessionTimeout = sessionTimeout;
    }

    public String toString() {
        return "ZooKeeperConnectionDescriptor [Name=" + this.getName() + ", SessionTimeout=" + this._SessionTimeout + ", RootPath=" + this._RootPath + ", Servers=" + this._Servers + "]";
    }
}

