/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.data;

import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import org.apache.zookeeper.ServerAdminClient;

public final class ZooKeeperServer {
    public static final String COMMAND_DUMP = "dump";
    public static final String COMMAND_GET_TRACE_MASK = "gettracemask";
    public static final String COMMAND_RUOK = "ruok";
    public static final String COMMAND_STAT = "stat";
    public static final String[] COMMANDS = new String[]{"dump", "gettracemask", "ruok", "stat"};
    private final ZooKeeperServerDescriptor _Descriptor;

    public ZooKeeperServer(ZooKeeperServerDescriptor descriptor) {
        this._Descriptor = descriptor;
    }

    public String dump() {
        Stoppable outputCatcher = this.startOutputCatcher();
        ServerAdminClient.dump((String)this._Descriptor.getHost(), (int)this._Descriptor.getPort());
        return outputCatcher.stop();
    }

    public ZooKeeperServerDescriptor getDescriptor() {
        return this._Descriptor;
    }

    public String getTraceMask() {
        Stoppable outputCatcher = this.startOutputCatcher();
        ServerAdminClient.getTraceMask((String)this._Descriptor.getHost(), (int)this._Descriptor.getPort());
        return outputCatcher.stop();
    }

    public void kill() {
        ServerAdminClient.kill((String)this._Descriptor.getHost(), (int)this._Descriptor.getPort());
    }

    public String ruok() {
        Stoppable outputCatcher = this.startOutputCatcher();
        ServerAdminClient.ruok((String)this._Descriptor.getHost(), (int)this._Descriptor.getPort());
        return outputCatcher.stop();
    }

    public void setTraceMask(String traceMaskStr) {
        ServerAdminClient.setTraceMask((String)this._Descriptor.getHost(), (int)this._Descriptor.getPort(), (String)traceMaskStr);
    }

    public String stat() {
        Stoppable outputCatcher = this.startOutputCatcher();
        ServerAdminClient.stat((String)this._Descriptor.getHost(), (int)this._Descriptor.getPort());
        return outputCatcher.stop();
    }

    public String toString() {
        return "ZooKeeperServer [Descriptor=" + this._Descriptor + "]";
    }

    protected Stoppable startOutputCatcher() {
        DummyCacher outputCatcher = new DummyCacher();
        outputCatcher.start();
        return outputCatcher;
    }

    public class DummyCacher
    implements Stoppable {
        public void start() {
        }

        @Override
        public String stop() {
            return "";
        }
    }

    static interface Stoppable {
        public String stop();
    }
}

