/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.data;

import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;

public final class ZooKeeperServerDescriptor
implements Comparable<ZooKeeperServerDescriptor> {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_JMX_PORT = 2182;
    public static final int DEFAULT_PORT = 2181;
    public static final String ZOOKEEPER_JMX_DOMAIN_NAME = "org.apache.ZooKeeperService";
    private final String _Host;
    private final String _HostPortString;
    private JmxConnectionDescriptor _JmxConnectionDescriptor;
    private final int _Port;

    public ZooKeeperServerDescriptor(String host, int port) {
        this._Host = host;
        this._Port = port;
        this._HostPortString = String.valueOf(this._Host) + ":" + this._Port;
    }

    @Override
    public int compareTo(ZooKeeperServerDescriptor o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZooKeeperServerDescriptor other = (ZooKeeperServerDescriptor)obj;
        if (this._Host == null ? other._Host != null : !this._Host.equals(other._Host)) {
            return false;
        }
        if (this._JmxConnectionDescriptor == null ? other._JmxConnectionDescriptor != null : !this._JmxConnectionDescriptor.equals((Object)other._JmxConnectionDescriptor)) {
            return false;
        }
        return this._Port == other._Port;
    }

    public String getHost() {
        return this._Host;
    }

    public String getHostPortString() {
        return this._HostPortString;
    }

    public JmxConnectionDescriptor getJmxConnectionDescriptor() {
        return this._JmxConnectionDescriptor;
    }

    public int getPort() {
        return this._Port;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._Host == null ? 0 : this._Host.hashCode());
        result = 31 * result + (this._JmxConnectionDescriptor == null ? 0 : this._JmxConnectionDescriptor.hashCode());
        result = 31 * result + this._Port;
        return result;
    }

    public void setJmxConnectionDescriptor(JmxConnectionDescriptor jmxConnectionDescriptor) {
        this._JmxConnectionDescriptor = jmxConnectionDescriptor;
    }

    public String toString() {
        return "ZooKeeperServerDescriptor [Host=" + this._Host + ", Port=" + this._Port + ", JmxConnectionDescriptor=" + this._JmxConnectionDescriptor + "]";
    }
}

