/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.dialogs;

import com.fusesource.zk.core.dialogs.GridDialog;
import com.fusesource.zk.core.widgets.grid.GridComposite;
import com.fusesource.zk.core.widgets.grid.GridTextInput;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.AuthInfo;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddAuthInfoDialog
extends GridDialog {
    private static final String CONTROL_NAME_AUTH_STRING_TEXT = "Auth";
    private static final String CONTROL_NAME_SCHEME_TEXT = "Scheme";
    private static final String CONTROL_NAME_TYPE_COMBO = "Type";
    private static final String MESSAGE = "Add authentication information to the ZooKeeper connection.";
    private static final String TITLE = "Add Authentication Information";
    private AuthInfo _AuthInfo;

    public AddAuthInfoDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle(TITLE);
        this.setTitleImage(ZooKeeperActivator.getManagedImage("IMAGE_KEY_DIALOG_ADD_AUTH_INFO"));
        this.setMessage(MESSAGE);
        Shell shell = this.getShell();
        shell.setText(TITLE);
    }

    public AuthInfo getAuthInfo() {
        return this._AuthInfo;
    }

    protected GridComposite createGridComposite(Composite parent) {
        GridComposite gridComposite = new GridComposite(parent){

            public void init() {
                this.setNumColumns(3);
                super.init();
                Text schemeText = (Text)this.getControl(AddAuthInfoDialog.CONTROL_NAME_SCHEME_TEXT);
                schemeText.forceFocus();
            }

            protected void createContents() {
                Label typeLabel = new Label((Composite)this, 16384);
                typeLabel.setText("&Type:   ");
                typeLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                final CCombo typeCombo = new CCombo((Composite)this, 2056);
                typeCombo.add(AuthInfo.Type.Text.name());
                typeCombo.add(AuthInfo.Type.File.name());
                typeCombo.select(0);
                typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                this.addControl(AddAuthInfoDialog.CONTROL_NAME_TYPE_COMBO, (Control)typeCombo);
                GridTextInput schemeGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, AddAuthInfoDialog.CONTROL_NAME_SCHEME_TEXT, "&Scheme: ", null, 2);
                this.addGridTextInput(schemeGridTextInput);
                schemeGridTextInput.getText().setTextLimit(250);
                GridTextInput authStringGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, AddAuthInfoDialog.CONTROL_NAME_AUTH_STRING_TEXT, "&Auth:     ", null);
                this.addGridTextInput(authStringGridTextInput);
                final Button browseButton = new Button((Composite)this, 8);
                browseButton.setText("&Browse...");
                browseButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                final Button showPasswordTextCheckBox = new Button((Composite)this, 32);
                showPasswordTextCheckBox.setText("Show auth text");
                showPasswordTextCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
                showPasswordTextCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Text authStringText = (Text)this.getControl(AddAuthInfoDialog.CONTROL_NAME_AUTH_STRING_TEXT);
                        char echoChar = showPasswordTextCheckBox.getSelection() ? (char)'\u0000' : '*';
                        authStringText.setEchoChar(echoChar);
                    }
                });
                final Label noteLabel = new Label((Composite)this, 16448);
                noteLabel.setText("NOTE:  Authentication information will be stored unencrypted in a file");
                noteLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
                browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Text authStringText = (Text)this.getControl(AddAuthInfoDialog.CONTROL_NAME_AUTH_STRING_TEXT);
                        FileDialog fileDialog = new FileDialog(this.getShell());
                        fileDialog.setFileName(authStringText.getText());
                        String newPath = fileDialog.open();
                        if (newPath != null) {
                            authStringText.setText(newPath);
                        }
                    }
                });
                SelectionAdapter typeComboSelectionListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Text authStringText = (Text)this.getControl(AddAuthInfoDialog.CONTROL_NAME_AUTH_STRING_TEXT);
                        authStringText.setText("");
                        String typeString = typeCombo.getText();
                        AuthInfo.Type type = AuthInfo.Type.valueOf(typeString);
                        boolean isFileType = type == AuthInfo.Type.File;
                        browseButton.setVisible(isFileType);
                        showPasswordTextCheckBox.setVisible(!isFileType);
                        noteLabel.setVisible(!isFileType);
                        char echoChar = isFileType || showPasswordTextCheckBox.getSelection() ? (char)'\u0000' : '*';
                        authStringText.setEchoChar(echoChar);
                    }
                };
                typeCombo.addSelectionListener((SelectionListener)typeComboSelectionListener);
                typeComboSelectionListener.widgetSelected(null);
            }
        };
        return gridComposite;
    }

    protected void okPressed() {
        GridComposite gridComposite = this.getGridComposite();
        CCombo typeCombo = (CCombo)gridComposite.getControl(CONTROL_NAME_TYPE_COMBO);
        Text schemeText = (Text)gridComposite.getControl(CONTROL_NAME_SCHEME_TEXT);
        Text authStringText = (Text)gridComposite.getControl(CONTROL_NAME_AUTH_STRING_TEXT);
        AuthInfo.Type type = AuthInfo.Type.valueOf(typeCombo.getText());
        String scheme = schemeText.getText();
        String authString = authStringText.getText();
        this._AuthInfo = new AuthInfo(type, scheme, authString);
        super.okPressed();
    }
}

