/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.znodeform;

import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelDataFormPage;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelFormEditor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class BaseZnodeModelDataEditor
extends Composite {
    private boolean _ActiveEditor;
    private final ZnodeModelDataFormPage _DataZnodeFormPage;
    private boolean _Dirty;
    private boolean _ProgrammaticUpdate;

    public BaseZnodeModelDataEditor(ZnodeModelDataFormPage dataZnodeFormPage, Composite parent, int style) {
        super(parent, style);
        this._DataZnodeFormPage = dataZnodeFormPage;
        this._DataZnodeFormPage.getManagedForm().getToolkit().adapt((Composite)this);
        this.setLayout(this.createLayout());
        this.createContent();
    }

    public final ZnodeModelDataFormPage getDataZnodeFormPage() {
        return this._DataZnodeFormPage;
    }

    public IManagedForm getManagedForm() {
        return this.getDataZnodeFormPage().getManagedForm();
    }

    public FormToolkit getToolkit() {
        return this.getManagedForm().getToolkit();
    }

    public abstract byte[] getZnodeDataFromEditor() throws Exception;

    public final ZnodeModelFormEditor getZnodeEditor() {
        return (ZnodeModelFormEditor)this.getDataZnodeFormPage().getEditor();
    }

    public final ZnodeModel getZnodeModel() {
        return (ZnodeModel)this.getDataZnodeFormPage().getModel();
    }

    public boolean isActiveEditor() {
        return this._ActiveEditor;
    }

    public boolean isDirty() {
        return this._Dirty;
    }

    public boolean isProgrammaticUpdate() {
        return this._ProgrammaticUpdate;
    }

    public void setActiveEditor(boolean active) {
        this._ActiveEditor = active;
        if (active && !this.isDirty()) {
            this.syncZnodeModelData();
        }
    }

    public void setDirty(boolean dirty) {
        this._Dirty = dirty;
    }

    public void setProgrammaticUpdate(boolean programmaticUpdate) {
        this._ProgrammaticUpdate = programmaticUpdate;
    }

    public final void syncZnodeModelData() {
        this.setProgrammaticUpdate(true);
        this.hookSyncZnodeModelData(this.getZnodeModel());
        this.setProgrammaticUpdate(false);
    }

    protected abstract void createContent();

    protected Layout createLayout() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 8;
        formLayout.marginWidth = 8;
        formLayout.spacing = 8;
        return formLayout;
    }

    protected abstract void hookSyncZnodeModelData(ZnodeModel var1);

    protected final void setDirtyInternal(boolean dirty) {
        if (this.isProgrammaticUpdate()) {
            return;
        }
        this.setDirty(dirty);
        this.getDataZnodeFormPage().setDirtyInternal(dirty);
    }
}

