/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.znodeform;

import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.editors.znodeform.BaseZnodeModelTableFormPage;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelFormEditor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.widgets.OrchestrationComposite;
import com.fusesource.zk.zookeeper.widgets.ZnodeAclComposite;
import java.util.EventObject;
import java.util.List;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ZnodeModelAclFormPage
extends BaseZnodeModelTableFormPage {
    public static final String ID = ZnodeModelAclFormPage.class.getName();
    public static final Image IMAGE = ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZNODE_ACL");
    public static final String TITLE = "ACL";
    private ZnodeAclComposite _ZnodeAclComposite;

    public ZnodeModelAclFormPage(ZnodeModelFormEditor editor) {
        super(editor, ID, TITLE, IMAGE);
    }

    public List<ACL> getZnodeAclFromEditor() {
        return this._ZnodeAclComposite.getZnodeAclFromTable();
    }

    @Override
    protected Table createTable(IManagedForm managedForm, Composite client) {
        FormToolkit toolkit = managedForm.getToolkit();
        this._ZnodeAclComposite = new ZnodeAclComposite(client, 0);
        toolkit.adapt((Composite)this._ZnodeAclComposite);
        FormLayout compositeLayout = new FormLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        compositeLayout.spacing = 8;
        this._ZnodeAclComposite.setLayout((Layout)compositeLayout);
        this._ZnodeAclComposite.setLayoutData(client.getLayoutData());
        this._ZnodeAclComposite.addOrchestrationCompositeListener(new OrchestrationComposite.IOrchestrationCompositeListener(){

            @Override
            public void orchestrationChange(EventObject e) {
                ZnodeModelAclFormPage.this.setDirtyInternal(true);
            }
        });
        Table table = super.createTable(managedForm, this._ZnodeAclComposite);
        this._ZnodeAclComposite.setTable(table);
        Button addButton = toolkit.createButton((Composite)this._ZnodeAclComposite, "&Add", 8);
        this._ZnodeAclComposite.setAddButton(addButton);
        Button removeButton = toolkit.createButton((Composite)this._ZnodeAclComposite, "&Remove", 8);
        this._ZnodeAclComposite.setRemoveButton(removeButton);
        Button setIdButton = toolkit.createButton((Composite)this._ZnodeAclComposite, "&Set Id...", 8);
        this._ZnodeAclComposite.setSetIdButton(setIdButton);
        FormData addButtonFormData = new FormData();
        addButtonFormData.top = new FormAttachment(0, 0);
        addButtonFormData.left = new FormAttachment((Control)removeButton, 0, 16384);
        addButtonFormData.right = new FormAttachment(100, 0);
        addButton.setLayoutData((Object)addButtonFormData);
        FormData removeButtonFormData = new FormData();
        removeButtonFormData.top = new FormAttachment((Control)addButton, 0);
        removeButtonFormData.right = new FormAttachment(100, 0);
        removeButton.setLayoutData((Object)removeButtonFormData);
        FormData setIdButtonFormData = new FormData();
        setIdButtonFormData.top = new FormAttachment((Control)removeButton, 0);
        setIdButtonFormData.right = new FormAttachment(100, 0);
        setIdButton.setLayoutData((Object)setIdButtonFormData);
        this._ZnodeAclComposite.init();
        SelectionAdapter yesListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeModelAclFormPage.this.initFromModel();
                ZnodeModelAclFormPage.this.setInfoText(null);
            }
        };
        this.initYesNoInfoBar(managedForm, (SelectionListener)yesListener);
        return table;
    }

    protected void forceLayout() {
        super.forceLayout();
        if (this._ZnodeAclComposite != null) {
            this._ZnodeAclComposite.layout(true);
        }
    }

    @Override
    protected int[] getTableColumnAlignments() {
        return null;
    }

    @Override
    protected String[] getTableColumnTitles() {
        return ZnodeAclComposite.TABLE_COLUMN_TITLES;
    }

    @Override
    protected int[] getTableColumnWidths() {
        return ZnodeAclComposite.TABLE_COLUMN_WIDTHS;
    }

    @Override
    protected FormData getTableFormData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment((Control)this._ZnodeAclComposite.getAddButton(), 0, 16384);
        return formData;
    }

    @Override
    protected int getTableStyle() {
        return 65540;
    }

    @Override
    protected void initTableItemsFromZnode() {
        this._ZnodeAclComposite.initTableItemsFromZnode((Znode)((ZnodeModel)this.getModel()).getData());
        this.setToolbarLabelText("aversion: " + ((Znode)((ZnodeModel)this.getModel()).getData()).getStat().getAversion(), "The number of changes to the ACL of this znode.");
    }

    protected void modelModifiedExternally() {
        ZnodeModel znodeModel = (ZnodeModel)this.getModel();
        if (znodeModel.isDestroyed()) {
            return;
        }
        ZnodeModelFormEditor editor = (ZnodeModelFormEditor)this.getEditor();
        Znode znode = (Znode)znodeModel.getData();
        Stat stat = znode.getStat();
        if (!this.isDirty() || stat.getAversion() == editor.getLastModificationAversion()) {
            this.initFromModel();
        } else {
            editor.setActivePage(ID);
            this.setInfoText("The Znode has been modified outside of this editor.  Do you want to reload it?");
        }
    }

    protected void saveCompleted() {
        super.saveCompleted();
        this.setInfoText(null);
        this.initFromModel();
    }
}

