/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.znodeform;

import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.actions.RefreshAction;
import com.fusesource.zk.core.viewers.ElementTypes;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.viewers.ViewerFactory;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.actions.NewZnodeAction;
import com.fusesource.zk.zookeeper.actions.TableEditAction;
import com.fusesource.zk.zookeeper.actions.TableEditChildrenAction;
import com.fusesource.zk.zookeeper.actions.ZooKeeperDeleteAction;
import com.fusesource.zk.zookeeper.actions.ZooKeeperOpenAction;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.editors.znodeform.BaseZnodeModelTableFormPage;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelFormEditor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.viewers.ZnodeModelElementType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IManagedForm;

public class ZnodeModelChildrenFormPage
extends BaseZnodeModelTableFormPage {
    public static final String ID = ZnodeModelChildrenFormPage.class.getName();
    public static final Image IMAGE = ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZNODE_CHILDREN");
    public static final String TITLE = "Children";
    private ZooKeeperDeleteAction _DeleteAction;
    private NewZnodeAction _NewZnodeAction;
    private ZooKeeperOpenAction _OpenAction;
    private RefreshAction _RefreshAction;
    private TableEditAction _TableEditAction;
    private TableEditChildrenAction _TableEditChildrenAction;
    private TableViewer _TableViewer;
    private ZnodeModelElementType _ZnodeModelElementType = new ZnodeModelElementType();

    public ZnodeModelChildrenFormPage(ZnodeModelFormEditor editor) {
        super(editor, ID, TITLE, IMAGE);
    }

    @Override
    protected Table createTable(IManagedForm managedForm, Composite client) {
        Table table = super.createTable(managedForm, client);
        table.setLinesVisible(false);
        ElementTypes elementTypes = new ElementTypes();
        elementTypes.add(ZnodeModel.class, (IElementType)this._ZnodeModelElementType);
        this._TableViewer = ViewerFactory.createDataModelTableViewer((Table)table, (ElementTypes)elementTypes, null);
        this.makeTableActions();
        this.hookTableContextMenu();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ZnodeModelChildrenFormPage.this.getSite().getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ZnodeModelChildrenFormPage.this.getEditor());
            }
        });
        return table;
    }

    @Override
    protected int[] getTableColumnAlignments() {
        return this._ZnodeModelElementType.getColumnAlignments();
    }

    @Override
    protected String[] getTableColumnTitles() {
        return this._ZnodeModelElementType.getColumnTitles();
    }

    @Override
    protected int[] getTableColumnWidths() {
        return this._ZnodeModelElementType.getColumnWidths();
    }

    @Override
    protected int getTableStyle() {
        return 770;
    }

    @Override
    protected void initTableItemsFromZnode() {
        ZnodeModel model = (ZnodeModel)this.getModel();
        this._TableViewer.setInput((Object)model);
        this.setToolbarLabelText("cversion: " + ((Znode)model.getData()).getStat().getCversion(), "The number of changes to the children of this znode.");
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this._TableViewer.getSelection().isEmpty()) {
            return;
        }
        manager.add((IAction)this._NewZnodeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this._OpenAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this._TableEditAction);
        manager.add((IAction)this._TableEditChildrenAction);
        manager.add((IContributionItem)new Separator());
        if (this._DeleteAction.isEnabled()) {
            manager.add((IAction)this._DeleteAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this._RefreshAction);
    }

    private void hookTableContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ZnodeModelChildrenFormPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this._TableViewer.getControl());
        this._TableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._TableViewer);
    }

    private void makeTableActions() {
        this._DeleteAction = new ZooKeeperDeleteAction();
        this._DeleteAction.setSelectionProvider((ISelectionProvider)this._TableViewer);
        this._TableEditChildrenAction = new TableEditChildrenAction();
        this._TableEditChildrenAction.setSelectionProvider((ISelectionProvider)this._TableViewer);
        this._TableEditAction = new TableEditAction();
        this._TableEditAction.setSelectionProvider((ISelectionProvider)this._TableViewer);
        this._NewZnodeAction = new NewZnodeAction(BaseAction.InputType.SINGLE_STRUCTURED_SELECTION);
        this._NewZnodeAction.setSelectionProvider((ISelectionProvider)this._TableViewer);
        this._OpenAction = new ZooKeeperOpenAction();
        this._OpenAction.setSelectionProvider((ISelectionProvider)this._TableViewer);
        this._RefreshAction = new RefreshAction(BaseAction.InputType.STRUCTURED_SELECTION);
        this._RefreshAction.setSelectionProvider((ISelectionProvider)this._TableViewer);
    }
}

