/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.znodeform;

import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.editors.znodeform.BaseZnodeModelDataEditor;
import com.fusesource.zk.zookeeper.editors.znodeform.BaseZnodeModelFormPage;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelFileDataEditor;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelFormEditor;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelTextDataEditor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.zookeeper.data.Stat;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fusesource.scalate.util.Files;

public class ZnodeModelDataFormPage
extends BaseZnodeModelFormPage {
    public static final String ID = ZnodeModelDataFormPage.class.getName();
    protected static Set<String> textExtensions = new HashSet<String>(Arrays.asList("xml", "properties", "json"));
    public static final Image IMAGE = ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZNODE_DATA");
    public static final String TITLE = "Data";
    private static final int DEFAULT_EDIT_MODE_DATA_SCAN_RANGE = 200;
    private BaseZnodeModelDataEditor _ActiveEditor;
    private EditMode _EditMode;
    private Button _FileDataRadioButton;
    private ZnodeModelFileDataEditor _FileZnodeDataEditor;
    private Button _SingleLineTextDataRadioButton;
    private ZnodeModelTextDataEditor _SingleLineTextZnodeDataEditor;
    private Composite _StackComposite;
    private final List<BaseZnodeModelDataEditor> _ZnodeDataEditors = new CopyOnWriteArrayList<BaseZnodeModelDataEditor>();

    public ZnodeModelDataFormPage(ZnodeModelFormEditor editor) {
        super(editor, ID, TITLE, IMAGE);
    }

    public EditMode getEditMode() {
        return this._EditMode;
    }

    public byte[] getZnodeDataFromEditor() throws Exception {
        return this._ActiveEditor.getZnodeDataFromEditor();
    }

    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        this.setEditModeSelectionEnabled(!dirty);
        if (!dirty) {
            for (BaseZnodeModelDataEditor dataEditor : this._ZnodeDataEditors) {
                dataEditor.setDirty(false);
            }
        }
    }

    public void setEditMode(EditMode editMode) {
        this._EditMode = editMode;
        BaseZnodeModelDataEditor activeEditor = null;
        switch (this._EditMode) {
            case SINGLE_LINE_TEXT: {
                this._FileDataRadioButton.setSelection(false);
                this._SingleLineTextDataRadioButton.setSelection(true);
                if (this._SingleLineTextZnodeDataEditor == null) {
                    this.createSingleLineTextZnodeDataEditor();
                }
                activeEditor = this._SingleLineTextZnodeDataEditor;
                break;
            }
            case FILE: {
                this._SingleLineTextDataRadioButton.setSelection(false);
                this._FileDataRadioButton.setSelection(true);
                if (this._FileZnodeDataEditor == null) {
                    this.createFileZnodeDataEditor();
                }
                activeEditor = this._FileZnodeDataEditor;
            }
        }
        if (activeEditor != null && activeEditor != this._ActiveEditor) {
            if (this._ActiveEditor != null) {
                this._ActiveEditor.setActiveEditor(false);
            }
            this._ActiveEditor = activeEditor;
            StackLayout stackLayout = (StackLayout)this._StackComposite.getLayout();
            stackLayout.topControl = this._ActiveEditor;
            this.forceLayout();
            this._ActiveEditor.forceFocus();
            this._ActiveEditor.setActiveEditor(true);
        }
    }

    protected Layout createClientLayout() {
        FormLayout clientLayout = (FormLayout)super.createClientLayout();
        clientLayout.spacing = 10;
        clientLayout.marginBottom = 10;
        return clientLayout;
    }

    protected void createModelFormContent(IManagedForm managedForm, Composite client) {
        SelectionAdapter yesListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeModelDataFormPage.this._ActiveEditor.syncZnodeModelData();
                ZnodeModelDataFormPage.this.setDirtyInternal(false);
                ZnodeModelDataFormPage.this.setInfoText(null);
                ZnodeModelDataFormPage.this.updateToolbarLabelText();
            }
        };
        this.initYesNoInfoBar(managedForm, (SelectionListener)yesListener);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite editModeComposite = toolkit.createComposite(client);
        FormLayout layout = new FormLayout();
        layout.spacing = 12;
        editModeComposite.setLayout((Layout)layout);
        Label editModeLabel = toolkit.createLabel(editModeComposite, "Edit Mode: ", 16384);
        this._SingleLineTextDataRadioButton = toolkit.createButton(editModeComposite, "&Text", 16);
        this._SingleLineTextDataRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeModelDataFormPage.this.setEditMode(EditMode.SINGLE_LINE_TEXT);
            }
        });
        this._FileDataRadioButton = toolkit.createButton(editModeComposite, "&File", 16);
        this._FileDataRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeModelDataFormPage.this.setEditMode(EditMode.FILE);
            }
        });
        Label separator = toolkit.createSeparator(client, 256);
        this._StackComposite = toolkit.createComposite(client);
        StackLayout stackLayout = new StackLayout();
        stackLayout.marginWidth = 0;
        this._StackComposite.setLayout((Layout)stackLayout);
        FormData editModeCompositeFormData = new FormData();
        editModeCompositeFormData.top = new FormAttachment(0, 0);
        editModeCompositeFormData.left = new FormAttachment(0, 0);
        editModeCompositeFormData.right = new FormAttachment(100, 0);
        editModeComposite.setLayoutData((Object)editModeCompositeFormData);
        FormData editModeLabelFormData = new FormData();
        editModeLabelFormData.top = new FormAttachment(0, 0);
        editModeLabelFormData.left = new FormAttachment(0, 0);
        editModeLabel.setLayoutData((Object)editModeLabelFormData);
        FormData singleLineTextDataButtonFormData = new FormData();
        singleLineTextDataButtonFormData.top = new FormAttachment((Control)editModeLabel, 0, 0x1000000);
        singleLineTextDataButtonFormData.left = new FormAttachment((Control)editModeLabel, 4);
        this._SingleLineTextDataRadioButton.setLayoutData((Object)singleLineTextDataButtonFormData);
        FormData fileDataButtonFormData = new FormData();
        fileDataButtonFormData.top = new FormAttachment((Control)this._SingleLineTextDataRadioButton, 0, 0x1000000);
        fileDataButtonFormData.left = new FormAttachment((Control)this._SingleLineTextDataRadioButton, 0);
        this._FileDataRadioButton.setLayoutData((Object)fileDataButtonFormData);
        FormData separatorFormData = new FormData();
        separatorFormData.top = new FormAttachment((Control)editModeComposite);
        separatorFormData.left = new FormAttachment(0, 0);
        separatorFormData.right = new FormAttachment(100, 0);
        separator.setLayoutData((Object)separatorFormData);
        FormData stackCompositeFormData = new FormData();
        stackCompositeFormData.top = new FormAttachment((Control)separator);
        stackCompositeFormData.left = new FormAttachment(0, 0);
        stackCompositeFormData.right = new FormAttachment(100, 0);
        stackCompositeFormData.bottom = new FormAttachment(100, 0);
        this._StackComposite.setLayoutData((Object)stackCompositeFormData);
    }

    protected void forceLayout() {
        super.forceLayout();
        if (this._StackComposite != null) {
            this._StackComposite.layout(true);
        }
    }

    protected void modelModifiedExternally() {
        ZnodeModel znodeModel = (ZnodeModel)this.getModel();
        if (znodeModel.isDestroyed()) {
            return;
        }
        ZnodeModelFormEditor editor = (ZnodeModelFormEditor)this.getEditor();
        Znode znode = (Znode)znodeModel.getData();
        Stat stat = znode.getStat();
        if (!this.isDirty() || stat.getVersion() == editor.getLastModificationVersion()) {
            this._ActiveEditor.syncZnodeModelData();
            this.updateToolbarLabelText();
        } else {
            editor.setActivePage(ID);
            this.setInfoText("The Znode has been modified outside of this editor.  Do you want to reload it?");
        }
    }

    protected void saveCompleted() {
        super.saveCompleted();
        this.setInfoText(null);
    }

    private void createFileZnodeDataEditor() {
        this._FileZnodeDataEditor = new ZnodeModelFileDataEditor(this, this._StackComposite, 0);
        this._ZnodeDataEditors.add(this._FileZnodeDataEditor);
    }

    private void createSingleLineTextZnodeDataEditor() {
        this._SingleLineTextZnodeDataEditor = new ZnodeModelTextDataEditor(this, this._StackComposite, 0);
        this._ZnodeDataEditors.add(this._SingleLineTextZnodeDataEditor);
    }

    private void setDefaultEditMode() {
        byte[] data;
        EditMode defaultEditMode = EditMode.SINGLE_LINE_TEXT;
        ZnodeModel znodeModel = (ZnodeModel)this.getModel();
        Znode znode = (Znode)znodeModel.getData();
        String path = znode.getPath();
        String ext = Files.extension((String)path);
        if (!(ext != null && textExtensions.contains(ext.toLowerCase()) || (data = znode.getData()) == null)) {
            int scanRange = Math.min(200, data.length);
            int i = 0;
            while (i < scanRange) {
                byte b = data[i];
                if (b > 9 && b < 14) {
                    defaultEditMode = EditMode.FILE;
                    break;
                }
                ++i;
            }
        }
        this.setEditMode(defaultEditMode);
    }

    private void setEditModeSelectionEnabled(boolean enabled) {
        this._SingleLineTextDataRadioButton.setEnabled(enabled);
        this._FileDataRadioButton.setEnabled(enabled);
    }

    private void updateToolbarLabelText() {
        this.setToolbarLabelText("version: " + ((Znode)((ZnodeModel)this.getModel()).getData()).getStat().getVersion(), "The number of changes to the data of this znode.");
    }

    protected void initFromModelInternal() {
        this.setDefaultEditMode();
        this.updateToolbarLabelText();
    }

    public static enum EditMode {
        FILE,
        SINGLE_LINE_TEXT;

    }
}

