/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.znodeform;

import com.fusesource.zk.core.ui.FileEditor;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.editors.znodeform.BaseZnodeModelDataEditor;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelDataFormPage;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ZnodeModelFileDataEditor
extends BaseZnodeModelDataEditor {
    private static final String[] FILTER_EXTENSIONS = new String[]{".txt", ".xml", ".properties", "*.*"};
    private static final String[] FILTER_NAMES = new String[]{"Text (*.txt)", "XML (*.xml)", "Properties (*.properties)", "All (*.*)"};
    private static final String EXPORT_BUTTON_TEXT = "Export.  Edit Znode's data in a file editor.";
    private static final String IMPORT_BUTTON_TEXT = "Import.  Replace Znode's data with the contents of a file.";
    private static final String SAVE_MESSAGE_LABEL_TEXT = "NOTE: 'Save' will replace the Znode's data with the contents of the file:";
    private Button _ExportButton;
    private List<Control> _ExportControls;
    private Button _ExportEditorPreferenceCheckBox;
    private FileEditor _ExportFileEditor;
    private Label _ExportLabel;
    private Button _ExportRadioButton;
    private Text _ExportText;
    private FileEditMode _FileEditMode;
    private ImageHyperlink _FileImageHyperlink;
    private Button _ImportButton;
    private List<Control> _ImportControls;
    private Label _ImportLabel;
    private Button _ImportRadioButton;
    private Text _ImportText;
    private Composite _SaveMessageComposite;

    public ZnodeModelFileDataEditor(ZnodeModelDataFormPage dataZnodeFormPage, Composite parent, int style) {
        super(dataZnodeFormPage, parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ZnodeModelFileDataEditor.this._ExportFileEditor != null) {
                    ZnodeModelFileDataEditor.this._ExportFileEditor.dispose();
                }
            }
        });
    }

    public FileEditMode getFileEditMode() {
        return this._FileEditMode;
    }

    @Override
    public byte[] getZnodeDataFromEditor() throws IOException {
        File file = null;
        FileEditor fileEditor = null;
        if (this._FileEditMode == FileEditMode.IMPORT) {
            String filePath = this._ImportText.getText();
            file = new File(filePath);
            fileEditor = new FileEditor(file);
        } else if (this._FileEditMode == FileEditMode.EXPORT) {
            fileEditor = this._ExportFileEditor;
            file = fileEditor.getFile();
        }
        String fileName = file.getName();
        if (!file.exists()) {
            throw new IOException("File '" + fileName + "' does not exist.");
        }
        if (!file.isFile()) {
            throw new IOException("Path '" + file.getAbsolutePath() + "' is not a valid file.");
        }
        long length = file.length();
        if (length > 0x100000L) {
            throw new IOException("File '" + fileName + "' size is greater than the maximum allowed Znode data size (" + 0x100000L + " bytes).");
        }
        return fileEditor.read();
    }

    @Override
    public void setDirty(boolean dirty) {
        boolean dirtyStateChanged = dirty ^ this.isDirty();
        super.setDirty(dirty);
        this._ImportRadioButton.setEnabled(!dirty || this._FileEditMode == FileEditMode.IMPORT);
        this._ExportRadioButton.setEnabled(!dirty || this._FileEditMode == FileEditMode.EXPORT);
        boolean exportControlsEnabled = !dirty && this._FileEditMode == FileEditMode.EXPORT;
        this._ExportButton.setEnabled(exportControlsEnabled);
        this._ExportEditorPreferenceCheckBox.setEnabled(exportControlsEnabled);
        this._SaveMessageComposite.setVisible(dirty);
        if (dirty) {
            Image fileImage;
            File file;
            String filePath;
            boolean preferIdeEditor = this._ExportEditorPreferenceCheckBox.getSelection();
            if (this._FileEditMode == FileEditMode.IMPORT) {
                filePath = this._ImportText.getText();
                file = new File(filePath);
                fileImage = FileEditor.getFileAssociationImage((String)filePath, (boolean)preferIdeEditor);
            } else {
                file = this._ExportFileEditor.getFile();
                filePath = file.getAbsolutePath();
                fileImage = this._ExportFileEditor.getFileAssociationImage();
            }
            this._FileImageHyperlink.setImage(fileImage);
            this._FileImageHyperlink.setText(file.getName());
            this._FileImageHyperlink.setToolTipText(filePath);
            this._FileImageHyperlink.setData((Object)file);
            this._FileImageHyperlink.setHref((Object)filePath);
            this._SaveMessageComposite.layout(true);
        } else if (dirtyStateChanged) {
            this._ImportText.setText("");
            this._ExportText.setText("");
            if (this._ExportFileEditor != null) {
                this._ExportFileEditor.dispose();
                this._ExportFileEditor = null;
            }
        }
    }

    public void setFileEditMode(FileEditMode fileEditMode) {
        this._FileEditMode = fileEditMode;
        if (this._FileEditMode == FileEditMode.IMPORT) {
            this.setControlsEnabled(this._ExportControls, false);
            this.setControlsEnabled(this._ImportControls, true);
        } else if (this._FileEditMode == FileEditMode.EXPORT) {
            this.setControlsEnabled(this._ImportControls, false);
            this.setControlsEnabled(this._ExportControls, true);
        }
    }

    @Override
    protected void createContent() {
        FormToolkit toolkit = this.getToolkit();
        this._ImportRadioButton = toolkit.createButton((Composite)this, IMPORT_BUTTON_TEXT, 16);
        this._ImportRadioButton.setSelection(true);
        this._ImportRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeModelFileDataEditor.this.setFileEditMode(FileEditMode.IMPORT);
            }
        });
        this._ImportControls = new ArrayList<Control>(3);
        this._ImportLabel = toolkit.createLabel((Composite)this, "File:");
        this._ImportControls.add((Control)this._ImportLabel);
        this._ImportText = toolkit.createText((Composite)this, null, 2052);
        this._ImportText.setEditable(false);
        this._ImportControls.add((Control)this._ImportText);
        this._ImportButton = toolkit.createButton((Composite)this, "Import...", 8);
        this._ImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeModelFileDataEditor.this.startImport();
            }
        });
        this._ImportControls.add((Control)this._ImportButton);
        this._ExportRadioButton = toolkit.createButton((Composite)this, EXPORT_BUTTON_TEXT, 16);
        this._ExportRadioButton.setSelection(false);
        this._ExportRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeModelFileDataEditor.this.setFileEditMode(FileEditMode.EXPORT);
            }
        });
        this._ExportControls = new ArrayList<Control>(4);
        this._ExportEditorPreferenceCheckBox = toolkit.createButton((Composite)this, "Prefer IDE editor", 32);
        this._ExportEditorPreferenceCheckBox.setSelection(true);
        this._ExportControls.add((Control)this._ExportEditorPreferenceCheckBox);
        this._ExportLabel = toolkit.createLabel((Composite)this, "File:");
        this._ExportControls.add((Control)this._ExportLabel);
        this._ExportText = toolkit.createText((Composite)this, null, 2052);
        this._ExportText.setEditable(false);
        this._ExportControls.add((Control)this._ExportText);
        this._ExportButton = toolkit.createButton((Composite)this, "Export...", 8);
        this._ExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeModelFileDataEditor.this.startExport();
            }
        });
        this._ExportControls.add((Control)this._ExportButton);
        this._SaveMessageComposite = toolkit.createComposite((Composite)this);
        toolkit.adapt(this._SaveMessageComposite);
        FormLayout saveMessageCompositeLayout = new FormLayout();
        saveMessageCompositeLayout.marginWidth = 0;
        saveMessageCompositeLayout.marginBottom = 0;
        saveMessageCompositeLayout.marginTop = 20;
        this._SaveMessageComposite.setLayout((Layout)saveMessageCompositeLayout);
        this._SaveMessageComposite.setVisible(false);
        Label saveMessageLabel = toolkit.createLabel(this._SaveMessageComposite, SAVE_MESSAGE_LABEL_TEXT, 16448);
        this._FileImageHyperlink = toolkit.createImageHyperlink(this._SaveMessageComposite, 0x1000000);
        this._FileImageHyperlink.setUnderlined(false);
        HyperlinkGroup hyperlinkGroup = new HyperlinkGroup(this.getDisplay());
        hyperlinkGroup.setHyperlinkUnderlineMode(2);
        hyperlinkGroup.add((Hyperlink)this._FileImageHyperlink);
        this._FileImageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                File file = (File)ZnodeModelFileDataEditor.this._FileImageHyperlink.getData();
                try {
                    FileEditor.editFile((File)file, (boolean)ZnodeModelFileDataEditor.this._ExportEditorPreferenceCheckBox.getSelection());
                }
                catch (Exception exception) {
                    Shell shell = ZnodeModelFileDataEditor.this.getShell();
                    MessageBox errorMessageBox = new MessageBox(shell, 33);
                    errorMessageBox.setMessage("Failed to open file '" + file + "'.");
                    errorMessageBox.setText("Open Failed");
                    errorMessageBox.open();
                }
            }
        });
        FormData importRadioButtonFormData = new FormData();
        importRadioButtonFormData.top = new FormAttachment(0, 0);
        importRadioButtonFormData.left = new FormAttachment(0, 0);
        importRadioButtonFormData.right = new FormAttachment(100, 0);
        this._ImportRadioButton.setLayoutData((Object)importRadioButtonFormData);
        FormData importLabelFormData = new FormData();
        importLabelFormData.top = new FormAttachment((Control)this._ImportRadioButton, 6, 1024);
        importLabelFormData.left = new FormAttachment((Control)this._ImportRadioButton, 12, 16384);
        this._ImportLabel.setLayoutData((Object)importLabelFormData);
        FormData importTextFormData = new FormData();
        importTextFormData.top = new FormAttachment((Control)this._ImportLabel, 0, 0x1000000);
        importTextFormData.left = new FormAttachment((Control)this._ImportLabel);
        importTextFormData.right = new FormAttachment((Control)this._ImportButton, 0, 16384);
        this._ImportText.setLayoutData((Object)importTextFormData);
        FormData importButtonFormData = new FormData();
        importButtonFormData.top = new FormAttachment((Control)this._ImportText, 0, 0x1000000);
        importButtonFormData.right = new FormAttachment(100, 0);
        this._ImportButton.setLayoutData((Object)importButtonFormData);
        FormData exportRadioButtonFormData = new FormData();
        exportRadioButtonFormData.top = new FormAttachment((Control)this._ImportLabel, 20);
        exportRadioButtonFormData.left = new FormAttachment(0, 0);
        exportRadioButtonFormData.right = new FormAttachment(100, 0);
        this._ExportRadioButton.setLayoutData((Object)exportRadioButtonFormData);
        FormData exportEditorPreferenceCheckBoxFormData = new FormData();
        exportEditorPreferenceCheckBoxFormData.top = new FormAttachment((Control)this._ExportRadioButton, 6, 1024);
        exportEditorPreferenceCheckBoxFormData.left = new FormAttachment((Control)this._ExportRadioButton, 12, 16384);
        exportEditorPreferenceCheckBoxFormData.right = new FormAttachment(100, 0);
        this._ExportEditorPreferenceCheckBox.setLayoutData((Object)exportEditorPreferenceCheckBoxFormData);
        FormData exportLabelFormData = new FormData();
        exportLabelFormData.top = new FormAttachment((Control)this._ExportEditorPreferenceCheckBox);
        exportLabelFormData.left = new FormAttachment((Control)this._ExportEditorPreferenceCheckBox, 0, 16384);
        this._ExportLabel.setLayoutData((Object)exportLabelFormData);
        FormData exportTextFormData = new FormData();
        exportTextFormData.top = new FormAttachment((Control)this._ExportLabel, 0, 0x1000000);
        exportTextFormData.left = new FormAttachment((Control)this._ExportLabel);
        exportTextFormData.right = new FormAttachment((Control)this._ExportButton, 0, 16384);
        this._ExportText.setLayoutData((Object)exportTextFormData);
        FormData exportButtonFormData = new FormData();
        exportButtonFormData.top = new FormAttachment((Control)this._ExportText, 0, 0x1000000);
        exportButtonFormData.right = new FormAttachment(100, 0);
        this._ExportButton.setLayoutData((Object)exportButtonFormData);
        FormData saveMessageCompositeFormData = new FormData();
        saveMessageCompositeFormData.top = new FormAttachment((Control)this._ExportText);
        saveMessageCompositeFormData.left = new FormAttachment(0, 0);
        saveMessageCompositeFormData.right = new FormAttachment(100, 0);
        saveMessageCompositeFormData.bottom = new FormAttachment(100, 0);
        this._SaveMessageComposite.setLayoutData((Object)saveMessageCompositeFormData);
        FormData saveMessageLabelFormData = new FormData();
        saveMessageLabelFormData.top = new FormAttachment(0, 0);
        saveMessageLabelFormData.left = new FormAttachment(0, 0);
        saveMessageLabelFormData.right = new FormAttachment(100, 0);
        saveMessageLabel.setLayoutData((Object)saveMessageLabelFormData);
        FormData fileImageHyperlinkFormData = new FormData();
        fileImageHyperlinkFormData.top = new FormAttachment((Control)saveMessageLabel, 6);
        fileImageHyperlinkFormData.left = new FormAttachment((Control)saveMessageLabel, 12, 16384);
        fileImageHyperlinkFormData.right = new FormAttachment(100, 0);
        this._FileImageHyperlink.setLayoutData((Object)fileImageHyperlinkFormData);
        this.setFileEditMode(FileEditMode.IMPORT);
    }

    @Override
    protected void hookSyncZnodeModelData(ZnodeModel znodeModel) {
    }

    private void setControlsEnabled(List<Control> controls, boolean enabled) {
        for (Control control : controls) {
            control.setEnabled(enabled);
        }
    }

    private void startExport() {
        ZnodeModel znodeModel = this.getZnodeModel();
        String prefix = ((Znode)znodeModel.getData()).getRelativePath();
        if (prefix.equals(Znode.ROOT_PATH)) {
            prefix = "root";
        }
        File directory = ZooKeeperActivator.getDefault().getZnodeDataDirectory();
        directory.mkdirs();
        FileDialog fileDialog = new FileDialog(this.getManagedForm().getForm().getShell(), 8192);
        fileDialog.setFileName(String.valueOf(prefix) + ".txt");
        fileDialog.setFilterExtensions(FILTER_EXTENSIONS);
        fileDialog.setFilterNames(FILTER_NAMES);
        fileDialog.setFilterPath(directory.getAbsolutePath());
        if (fileDialog.open() == null) {
            return;
        }
        String selectedPath = fileDialog.getFileName();
        Path path = new Path(selectedPath);
        String suffix = path.getFileExtension();
        if (suffix != null) {
            suffix.trim();
        } else {
            suffix = ".txt";
        }
        suffix = suffix.length() == 0 ? ".txt" : "." + suffix;
        Znode znode = (Znode)znodeModel.getData();
        byte[] data = znode.getData();
        try {
            this._ExportFileEditor = FileEditor.createTempFileEditor((String)prefix, (String)suffix, (File)directory, (byte[])data, (boolean)this._ExportEditorPreferenceCheckBox.getSelection());
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            this._ExportFileEditor.edit();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
        this._ExportText.setText(this._ExportFileEditor.getFile().getAbsolutePath());
        this.setDirtyInternal(true);
    }

    private void startImport() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFileName(this._ImportText.getText());
        String newPath = fileDialog.open();
        if (newPath != null) {
            this._ImportText.setText(newPath);
            this.setDirtyInternal(true);
        }
    }

    public static enum FileEditMode {
        EXPORT,
        IMPORT;

    }
}

