/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.znodeform;

import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.core.model.IGenericDataModelEventListener;
import com.fusesource.zk.core.reflect.SwtThreadSafeDelegatingInvocationHandler;
import com.fusesource.zk.core.viewers.DataModelElementType;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.actions.NewZnodeAction;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelAclFormPage;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelChildrenFormPage;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelDataFormPage;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelStatFormPage;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import com.fusesource.zk.zookeeper.viewers.ZnodeModelElementType;
import com.fusesource.zk.zookeeper.viewers.ZooKeeperConnectionModelElementType;
import java.util.List;
import org.apache.zookeeper.data.ACL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;

public final class ZnodeModelFormEditor
extends DataModelFormEditor<ZnodeModel> {
    public static final String ID = String.valueOf(ZnodeModelFormEditor.class.getName());
    private ZnodeModelAclFormPage _AclZnodeFormPage;
    private ZnodeModelChildrenFormPage _ChildrenZnodeFormPage;
    private ZnodeModelDataFormPage _DataZnodeFormPage;
    private int _LastModificationAversion = -1;
    private int _LastModificationVersion = -1;
    private NewZnodeAction _NewZnodeAction;
    private ZnodeModelStatFormPage _StatZnodeFormPage;
    private IGenericDataModelEventListener _ZooKeeperConnectionModelEventListener;

    public void doSave(IProgressMonitor monitor) {
        ZnodeModel znodeModel = (ZnodeModel)this.getModel();
        if (znodeModel.isDestroyed()) {
            return;
        }
        Znode znode = (Znode)znodeModel.getData();
        try {
            if (this._DataZnodeFormPage != null && this._DataZnodeFormPage.isDirty()) {
                byte[] data = null;
                try {
                    data = this._DataZnodeFormPage.getZnodeDataFromEditor();
                }
                catch (Exception e) {
                    Shell shell = this.getEditorSite().getShell();
                    MessageBox errorMessageBox = new MessageBox(shell, 33);
                    errorMessageBox.setMessage("Failed to save Znode data.  Error details: " + e.getMessage());
                    errorMessageBox.setText("Save Failed");
                    errorMessageBox.open();
                    monitor.setCanceled(true);
                    this._LastModificationVersion = -1;
                    this._LastModificationAversion = -1;
                    return;
                }
                znode.setData(data);
                znodeModel.setDirtyData(true);
                this._LastModificationVersion = znode.getStat().getVersion() + 1;
            }
            if (this._AclZnodeFormPage != null && this._AclZnodeFormPage.isDirty()) {
                List<ACL> acl = null;
                try {
                    acl = this._AclZnodeFormPage.getZnodeAclFromEditor();
                }
                catch (Exception e) {
                    Shell shell = this.getEditorSite().getShell();
                    MessageBox errorMessageBox = new MessageBox(shell, 33);
                    errorMessageBox.setMessage("Failed to save Znode ACL.  Error details: " + e.getMessage());
                    errorMessageBox.setText("Save Failed");
                    errorMessageBox.open();
                    monitor.setCanceled(true);
                    this._LastModificationVersion = -1;
                    this._LastModificationAversion = -1;
                    return;
                }
                znode.setAcl(acl);
                znodeModel.setDirtyAcl(true);
                this._LastModificationAversion = znode.getStat().getAversion() + 1;
            }
            if (znodeModel.isDirtyData() || znodeModel.isDirtyAcl()) {
                try {
                    znodeModel.updateData();
                    this.saveCompleted();
                }
                catch (DataModelSourceException e) {
                    ZooKeeperActivator.reportError(e);
                    monitor.setCanceled(true);
                }
            }
        }
        finally {
            this._LastModificationVersion = -1;
            this._LastModificationAversion = -1;
        }
    }

    public final int getLastModificationAversion() {
        return this._LastModificationAversion;
    }

    public int getLastModificationVersion() {
        return this._LastModificationVersion;
    }

    public String getModelDestroyedMessage() {
        String message = "Znode no longer exists";
        if (this.getZooKeeperConnectionModel().isDestroyed()) {
            message = String.valueOf(message) + " (ZooKeeper connection deleted)";
        }
        return message;
    }

    public ZooKeeperConnectionModel getZooKeeperConnectionModel() {
        ZnodeModel znodeModel = (ZnodeModel)this.getModel();
        if (znodeModel == null) {
            return null;
        }
        return znodeModel.getOwnerModel();
    }

    public boolean isDirty() {
        if (this.getZooKeeperConnectionModel().isDestroyed()) {
            return false;
        }
        return super.isDirty();
    }

    public void setFocus() {
        super.setFocus();
        this._NewZnodeAction.updateState();
    }

    protected void addPages() {
        try {
            this._DataZnodeFormPage = new ZnodeModelDataFormPage(this);
            this.addPage(this._DataZnodeFormPage);
            if (!((Znode)((ZnodeModel)this.getModel()).getData()).isEphemeral()) {
                this._ChildrenZnodeFormPage = new ZnodeModelChildrenFormPage(this);
                this.addPage(this._ChildrenZnodeFormPage);
            }
            this._AclZnodeFormPage = new ZnodeModelAclFormPage(this);
            this.addPage(this._AclZnodeFormPage);
            this._StatZnodeFormPage = new ZnodeModelStatFormPage(this);
            this.addPage(this._StatZnodeFormPage);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void contributeToToolBar(IManagedForm headerForm, IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this._NewZnodeAction);
        toolBarManager.add((IContributionItem)new Separator());
        super.contributeToToolBar(headerForm, toolBarManager);
    }

    protected DataModelElementType getOwnerModelElementType() {
        return new ZooKeeperConnectionModelElementType();
    }

    protected DataModelElementType getParentModelElementType() {
        return new ZnodeModelElementType();
    }

    protected String getFormText(ZnodeModel model) {
        return ((Znode)model.getData()).getPath();
    }

    protected void makeActions() {
        super.makeActions();
        this._NewZnodeAction = new NewZnodeAction(BaseAction.InputType.EDITOR_INPUT);
    }

    protected void registerModelEventListener() {
        super.registerModelEventListener();
        ZooKeeperConnectionModelEventListener zooKeeperConnectionModelEventListenerDelegate = new ZooKeeperConnectionModelEventListener();
        this._ZooKeeperConnectionModelEventListener = (IGenericDataModelEventListener)SwtThreadSafeDelegatingInvocationHandler.createProxyInstance((SwtThreadSafeDelegatingInvocationHandler.IWidgetProvider)zooKeeperConnectionModelEventListenerDelegate, IGenericDataModelEventListener.class, (boolean)true);
        this.getZooKeeperConnectionModel().addGenericEventListener(this._ZooKeeperConnectionModelEventListener);
    }

    protected void unregisterModelEventListener() {
        super.unregisterModelEventListener();
        if (this._ZooKeeperConnectionModelEventListener != null) {
            this.getZooKeeperConnectionModel().removeGenericEventListener(this._ZooKeeperConnectionModelEventListener);
        }
    }

    public final class ZooKeeperConnectionModelEventListener
    implements IGenericDataModelEventListener,
    SwtThreadSafeDelegatingInvocationHandler.IWidgetProvider {
        public void dataModelDataChanged(GenericDataModelEvent event) {
        }

        public void dataModelDataRefreshed(GenericDataModelEvent event) {
        }

        public void dataModelDestroyed(GenericDataModelEvent event) {
            if (ZnodeModelFormEditor.this.getContainer().isDisposed()) {
                return;
            }
            ZnodeModelFormEditor.this.editorDirtyStateChanged();
        }

        public Widget getWidget() {
            return ZnodeModelFormEditor.this.getContainer();
        }
    }
}

