/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.znodeform;

import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.editors.znodeform.BaseZnodeModelTableFormPage;
import com.fusesource.zk.zookeeper.editors.znodeform.ZnodeModelFormEditor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import java.text.DateFormat;
import java.util.Date;
import org.apache.zookeeper.data.Stat;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ZnodeModelStatFormPage
extends BaseZnodeModelTableFormPage {
    public static final String ID = ZnodeModelStatFormPage.class.getName();
    public static final Image IMAGE = ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZNODE_STAT");
    public static final String[] TABLE_COLUMN_TITLES = new String[]{"Name", "Value", "Description"};
    public static final String TITLE = "Stat";

    public ZnodeModelStatFormPage(ZnodeModelFormEditor editor) {
        super(editor, ID, TITLE, IMAGE);
    }

    @Override
    protected int[] getTableColumnAlignments() {
        return null;
    }

    @Override
    protected String[] getTableColumnTitles() {
        return TABLE_COLUMN_TITLES;
    }

    @Override
    protected int[] getTableColumnWidths() {
        return null;
    }

    @Override
    protected void initTableItemsFromZnode() {
        Table table = this.getTable();
        table.removeAll();
        ZnodeModel znodeModel = (ZnodeModel)this.getModel();
        Znode znode = (Znode)znodeModel.getData();
        Stat stat = znode.getStat();
        DateFormat format = DateFormat.getDateTimeInstance();
        String ctime = format.format(new Date(stat.getCtime()));
        String mtime = format.format(new Date(stat.getMtime()));
        this.addStatValueTableItem(table, "czxid", String.valueOf(stat.getCzxid()), "The zxid of the change that caused this znode to be created.");
        this.addStatValueTableItem(table, "mzxid", String.valueOf(stat.getMzxid()), "The zxid of the change that last modified this znode.");
        this.addStatValueTableItem(table, "ctime", ctime, "The time when this znode was created.");
        this.addStatValueTableItem(table, "mtime", mtime, "The time when this znode was last modified.");
        this.addStatValueTableItem(table, "version", String.valueOf(stat.getVersion()), "The number of changes to the data of this znode.");
        this.addStatValueTableItem(table, "cversion", String.valueOf(stat.getCversion()), "The number of changes to the children of this znode.");
        this.addStatValueTableItem(table, "aversion", String.valueOf(stat.getAversion()), "The number of changes to the ACL of this znode.");
        this.addStatValueTableItem(table, "ephemeralOwner", String.valueOf(stat.getEphemeralOwner()), "The session id of the owner of this znode if the znode is an ephemeral node.");
        this.addStatValueTableItem(table, "dataLength", String.valueOf(stat.getDataLength()), "The length of the data field of this znode.");
        this.addStatValueTableItem(table, "numChildren", String.valueOf(stat.getNumChildren()), "The number of children of this znode.");
    }

    private void addStatValueTableItem(Table table, String name, String value, String description) {
        TableItem item = new TableItem(table, 0);
        item.setText(0, name);
        item.setText(1, value);
        item.setText(2, description);
    }
}

