/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.zookeeperconnectionform;

import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.AuthInfo;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import com.fusesource.zk.zookeeper.editors.zookeeperconnectionform.ZooKeeperConnectionModelAuthenticationFormPage;
import com.fusesource.zk.zookeeper.editors.zookeeperconnectionform.ZooKeeperConnectionModelMainFormPage;
import com.fusesource.zk.zookeeper.editors.zookeeperconnectionform.ZooKeeperConnectionModelServersFormPage;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class ZooKeeperConnectionModelFormEditor
extends DataModelFormEditor<ZooKeeperConnectionModel> {
    public static final String ID = String.valueOf(ZooKeeperConnectionModelFormEditor.class.getName());
    private ZooKeeperConnectionModelAuthenticationFormPage _AuthenticationPage;
    private ZooKeeperConnectionModelMainFormPage _MainPage;
    private ZooKeeperConnectionModelServersFormPage _ServersPage;

    public void doSave(IProgressMonitor monitor) {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)this.getModel();
        if (model.isDestroyed()) {
            return;
        }
        ZooKeeperConnectionDescriptor descriptor = (ZooKeeperConnectionDescriptor)((Object)model.getKey());
        int sessionTimeout = descriptor.getSessionTimeout();
        String rootPath = descriptor.getRootPath();
        Set<ZooKeeperServerDescriptor> servers = descriptor.getServers();
        List<AuthInfo> authInfos = descriptor.getAuthInfos();
        String errorMessageTitle = "Save Failed";
        if (this._MainPage.isDirty()) {
            sessionTimeout = this._MainPage.getSessionTimeout();
            if (sessionTimeout <= 0) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)errorMessageTitle, (String)"Invalid session timeout value.");
                monitor.setCanceled(true);
                return;
            }
            rootPath = this._MainPage.getRootPath();
            try {
                Znode.validatePath(rootPath, false);
            }
            catch (IllegalArgumentException e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)errorMessageTitle, (String)("Invalid root path: " + e.getLocalizedMessage()));
                monitor.setCanceled(true);
                return;
            }
        }
        if (this._ServersPage.isDirty() && (servers = this._ServersPage.getServersFromTable()).isEmpty()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)errorMessageTitle, (String)"At least one server must be added.");
            monitor.setCanceled(true);
            return;
        }
        if (this._AuthenticationPage.isDirty()) {
            authInfos = this._AuthenticationPage.getAuthInfoFromTable();
        }
        try {
            if (this._MainPage.isDirty()) {
                descriptor.setRootPath(rootPath);
                descriptor.setSessionTimeout(sessionTimeout);
            }
            if (this._ServersPage.isDirty()) {
                descriptor.setServers(servers);
            }
            if (this._AuthenticationPage.isDirty()) {
                descriptor.setAuthInfos(authInfos);
            }
            model.updateData();
            this.saveCompleted();
        }
        catch (Exception e) {
            ZooKeeperActivator.reportError(e);
            monitor.setCanceled(true);
        }
    }

    protected void addPages() {
        try {
            this._MainPage = new ZooKeeperConnectionModelMainFormPage(this);
            this.addPage(this._MainPage);
            this._ServersPage = new ZooKeeperConnectionModelServersFormPage(this);
            this.addPage(this._ServersPage);
            this._AuthenticationPage = new ZooKeeperConnectionModelAuthenticationFormPage(this);
            this.addPage(this._AuthenticationPage);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected void modelDestroyed(GenericDataModelEvent event) {
        super.modelDestroyed(event);
        this.close(false);
    }
}

